% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{basis_guided}
\alias{basis_guided}
\title{The last basis of a guided tour}
\usage{
basis_guided(data, index_f = tourr::holes(), p = 2L, ...)
}
\arguments{
\item{data}{Numeric matrix or data.frame of the observations.}

\item{index_f}{The index function to optimize.
\code{{tourr}} exports \code{holes()}, \code{cmass()}, and \code{lda_pp(class)}.}

\item{p}{Number of dimensions in the projection space.}

\item{...}{Optional, other arguments to pass to \code{tourr::guided_tour}.}
}
\value{
Numeric matrix of the last basis of a guided tour.
}
\description{
The last basis of a guided tour
}
\examples{
basis_guided(data = wine[, 2:14], index_f = tourr::holes())

basis_guided(data = wine[, 2:14], index_f = tourr::cmass(),
             alpha = .4, cooling = .9, max.tries = 30)
}
\seealso{
\code{\link[tourr]{guided_tour}} for annealing arguments.
}
