% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{filmstrip}
\alias{filmstrip}
\title{Create a "filmstrip" of the frames of a ggtour.}
\usage{
filmstrip(ggtour, ...)
}
\arguments{
\item{ggtour}{A grammar of graphics tour with appended protos added.
A return from \verb{ggtour() + proto_*()}}

\item{...}{optionally pass arguments to ggplot2::facet_wrap, such as
nrow = 3, ncol = 2, scales = "free".}
}
\description{
Appends \code{facet_wrap(vars(frame_number))} & minor themes to the ggtour. If the
number of frames is more than desired, try increasing the \code{angle} argument on
the tour. Is very demanding on the plots pane, works better with ggsave().
}
\examples{
dat  <- scale_sd(penguins[, 1:4])
clas <- penguins$species
bas  <- basis_pca(dat)
mv   <- manip_var_of(bas)

## d = 2 case
mt_path <- manual_tour(bas, manip_var = mv)
ggt <- ggtour(mt_path, dat, angle = .3) +
  proto_point(list(color = clas, shape = clas),
              list(size = 1.5)) +
  proto_basis()
filmstrip(ggt)

## d = 1 case & specify facet dim
bas1d     <- basis_pca(dat, d = 1)
mt_path1d <- manual_tour(basis = bas1d, manip_var = mv)
ggt1d <- ggtour(mt_path1d, dat, angle = 10) +
  proto_default1d(aes_args = list(fill = clas))
filmstrip(ggt1d, nrow = 12, ncol = 3)
}
\seealso{
Other ggtour animator: 
\code{\link{animate_gganimate}()},
\code{\link{animate_plotly}()}
}
\concept{ggtour animator}
