% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_awesome_animate.R
\name{animateIcon}
\alias{animateIcon}
\title{Font awesome animated icons}
\usage{
animateIcon(
  name,
  animation = NULL,
  speed = NULL,
  hover = FALSE,
  color = "",
  size = NULL,
  ...
)
}
\arguments{
\item{name}{string, the name of the font-awesome icon}

\item{animation}{what kind of animation you want, one of "wrench", "ring",
"horizontal", "horizontal-reverse", "vertical", "flash", "bounce", "bounce-reverse",
"spin", "spin-reverse", "float", "pulse", "shake", "tada", "passing", "passing-reverse",
"burst", "falling", "falling-reverse", "rising"s
See our online demo for details.}

\item{speed}{string, one of "fast", "slow"}

\item{hover}{bool, trigger animation on hover?}

\item{color}{string, color of the icon, a valid color name or hex code}

\item{size}{string, change font-awesome icon size, one of "xs", "sm", "lg", "2x", "3x",
"5x", "7x", "10x". See examples.}

\item{...}{append additional attributes you want to the icon}
}
\value{
a icon tag
}
\description{
Greatly enhance the \link[shiny:icon]{shiny::icon} with animations. Built on top
of \href{https://github.com/l-lin/font-awesome-animation}{font-awesome-animation}.
}
\details{
If you don't specify any animation, it will work the same as the original
\link[shiny:icon]{shiny::icon} function. Fully compatible with any shiny functions that
requires an icon as input.
}
\examples{
if(interactive()){
  library(shiny)

  ui <- fluidPage(
    style = "text-align: center;",
    tags$label("same as original icon function"), br(),
    animateIcon("home"),  br(),
    tags$label("Change animation and color"), br(),
    animateIcon(
      name = "home", animation = "horizontal", speed = "slow", color ="red"
    ), br(),
    tags$label("work in a button"), br(),
    actionButton(
      "a", "a", icon = animateIcon("spinner", "spin", "fast")
    ), br(),
    tags$label("hover your mouse on the next one"), br(),
    animateIcon(
      name = "wrench", animation = "wrench", hover = TRUE, color ="green"
    ), br(),
    tags$label("change size"), br(),
    animateIcon("home"),
    animateIcon("home", size = "xs"),
    animateIcon("home", size = "sm"),
    animateIcon("home", size = "lg"),
    animateIcon("home", size = "2x"),
    animateIcon("home", size = "3x"),
    animateIcon("home", size = "5x"),
    animateIcon("home", size = "7x"),
    animateIcon("home", size = "10x")
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
