% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sreg_pips.R
\name{sreg_pips}
\alias{sreg_pips}
\title{Semiparametric Model-Assisted Estimation under a Proportional to Size Sampling Design}
\usage{
sreg_pips(location_formula, scale_formula, data, x, n)
}
\arguments{
\item{location_formula}{a symbolic description of the systematic component of the location model to be fitted.}

\item{scale_formula}{a symbolic description of the systematic component of the scale model to be fitted.}

\item{data}{a data frame, list containing the variables in the model.}

\item{x}{vector, an auxiliary variable to calculate the inclusion probabilities of each unit.}

\item{n}{numeric, sample size.}
}
\value{
\code{sampling_design} is the name of the sampling design used in the estimation process.

\code{N} is the population size.

\code{n} is the sample size used in the estimation process.

\code{first_order_probabilities} vector of the first order probabilities used in the estimation process.

\code{sample} is the random sample used in the estimation process.

\code{total_y_sreg} is the SREG estimate of the total parameter of the finite population.
}
\description{
\code{sreg_pips} is used to estimate the total parameter of a finite population generated from a semi-parametric generalized gamma population under a proportional to size without-replacement sampling design.
}
\examples{
library(survey)
library(dplyr)
data(api)
attach(apipop)
Apipop <- filter(apipop,full!= 'NA')
Apipop <- filter(Apipop, stype == 'H')
Apipop <- select(Apipop,c(api00,grad.sch,full,api99))
n=ceiling(0.2*dim(Apipop)[1])
aux_var <- select(Apipop,'api99')
sreg_pips(api00 ~  pb(grad.sch), scale_formula = ~ full - 1, data= Apipop, x= aux_var, n=n)
sum(Apipop$api00)
}
\references{
Sarndal C.E.,  Swensson B., and Wretman J. (2003). Model Assisted Survey Sampling. Springer.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
