% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prs.R
\name{prs.train}
\alias{prs.train}
\title{Polygenic risk score (given only allele frequencies); training}
\usage{
prs.train(pi0, pi1, n0, n1)
}
\arguments{
\item{pi0, pi1}{p x 1 vectors of control and case minor allele frequencies, respectively; IMPORTANT: must be relative to the same allele in both cases and controls}

\item{n0, n1}{number of controls and number of cases, respectively}
}
\value{
\item{pi0}{minor allele frequencies in controls}
\item{pi1}{minor allele frequencies in cases}
\item{P}{proportion of cases}
}
\description{
Equivalent to maximum likelihood naive Bayes classifier. The discriminant function is
\deqn{\sum_j\hat{\beta}_jX_j,}
where \eqn{X_j} is the additively coded genotype of SNP j.
}
\examples{
p <- 1000; ## number of snps
I <- rep(0,p); I[1:10] <- 1; ## which snps are causal
set.seed(1); pi0 <- runif(p,0.1,0.5); ## control minor allele frequencies
set.seed(1); ors <- runif(sum(I),-1,1); ## odds ratios
pi1 <- pi0;
pi1[I==1] <- expit(ors+logit(pi0[I==1]));
n0 <- 100; ## number of controls
X0 <- t(replicate(n0,rbinom(p,2,pi0))); ## controls
n1 <- 50; ## number of cases
X1 <- t(replicate(n1,rbinom(p,2,pi1))); ## cases
prs.train(colMeans(X0)/2,colMeans(X1)/2,n0,n1);

}

