% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hc.R
\name{ssd_hc}
\alias{ssd_hc}
\alias{ssd_hc.fitdist}
\alias{ssd_hc.fitdistcens}
\alias{ssd_hc.fitdists}
\alias{ssd_hc.fitdistscens}
\title{Hazard Concentration}
\usage{
ssd_hc(x, ...)

\method{ssd_hc}{fitdist}(x, hc = 5L, nboot = 1001, level = 0.95, ...)

\method{ssd_hc}{fitdistcens}(x, hc = 5L, nboot = 1001, level = 0.95,
  ...)

\method{ssd_hc}{fitdists}(x, hc = 5L, ic = "aicc", average = TRUE,
  nboot = 1001, level = 0.95, ...)

\method{ssd_hc}{fitdistscens}(x, hc = 5L, ic = "aic", average = TRUE,
  nboot = 1001, level = 0.95, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{hc}{A number between 0 and 1 indicating the percent hazard concentration to plot (or NULL).}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the se and confidence limits.}

\item{level}{The confidence level.}

\item{ic}{A string indicating which information-theoretic criterion ('aic', 'aicc' or 'bic') to use for model averaging.}

\item{average}{A flag indicating whether to model-average.}
}
\value{
A data frame of the estimate with the standard error and upper and lower confidence intervals.
}
\description{
Estimates with bootstrap confidence intervals the hazard concentration
at which by default 5\% of the species are affected.
}
\section{Methods (by class)}{
\itemize{
\item \code{fitdist}: Hazard Concentration

\item \code{fitdistcens}: Hazard Concentration

\item \code{fitdists}: Hazard Concentration

\item \code{fitdistscens}: Hazard Concentration
}}

\examples{
ssd_hc(boron_lnorm)
\dontrun{
ssd_hc(fluazinam_lnorm)
}
\dontrun{
ssd_hc(boron_dists)
}
\dontrun{
ssd_hc(fluazinam_dists)
}
}
