% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.fitdists}
\alias{tidy.fitdists}
\title{Turn a fitdists Object into a Tibble}
\usage{
\method{tidy}{fitdists}(x, all = FALSE, ...)
}
\arguments{
\item{x}{The object.}

\item{all}{A flag specifying whether to also return transformed parameters.}

\item{...}{Unused.}
}
\value{
A tidy tibble of the estimates and standard errors.
}
\description{
Turns a fitdists object into a tidy tibble of the
estimates (est) and standard errors (se) by the
terms (term) and distributions (dist).
}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
tidy(fits)
tidy(fits, all = TRUE)
}
\seealso{
\code{\link[=coef.fitdists]{coef.fitdists()}}

Other generics: 
\code{\link{augment.fitdists}()},
\code{\link{glance.fitdists}()}
}
\concept{generics}
