# Copyright 2015-2023 Province of British Columbia
# Copyright 2021 Environment and Climate Change Canada
# Copyright 2023-2024 Australian Government Department of Climate Change,
# Energy, the Environment and Water
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#       https://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

test_that("schwarz-tillmans", {
  set.seed(10)
  dists <- c(
    "gompertz", "weibull", "gamma", "lnorm", "llogis", "lgumbel"
  )
  fits <- ssd_fit_dists(ssddata::ccme_boron, dists = dists)

  hc <- ssd_hc(fits, average = FALSE, ci_method = "weighted_samples", multi_est = FALSE)
  expect_s3_class(hc, "tbl")
  expect_snapshot_data(hc, "hc")

  hc_avg <- ssd_hc(fits, average = TRUE, ci_method = "weighted_samples", multi_est = FALSE)
  expect_s3_class(hc_avg, "tbl")
  expect_snapshot_data(hc_avg, "hc_avg")

  gof <- ssd_gof(fits, pvalue = FALSE)
  expect_s3_class(gof, "tbl_df")
  expect_snapshot_data(gof, "gof")
})
