% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absorption_functions.R
\name{abs_parms}
\alias{abs_parms}
\title{Calculating slopes and slope ratios of a data frame of absorbance data.}
\usage{
abs_parms(abs_data, cuvle, limits = list(c(275, 295), c(350, 400), c(300,
  700)), l_ref = list(350, 350, 350), S = TRUE, lref = FALSE, p = FALSE,
  model = FALSE, cores = detectCores()/2)
}
\arguments{
\item{abs_data}{data frame containing absorbance data.}

\item{cuvle}{length of used cuvette in cm}

\item{limits}{list with vectors containig upper and lower bounds of wavelengeth ranges to be fitted}

\item{l_ref}{list with reference wavelengths, same length as limits}

\item{S}{logical, include slope parameter in the table}

\item{lref}{logical, include reference wavelength in the table}

\item{p}{logical, include ps of the coefficients in the table}

\item{model}{logical, include complete model in data frame}

\item{cores}{number of cores to be used for parallel processing}
}
\value{
A data frame containing the adsorption slopes and slope ratios in column, one line for each sample.
}
\description{
Calculating slopes and slope ratios of a data frame of absorbance data.
}
\details{
The absorbance data is a data frame with the first column called "wavelength" containg the wavelength. Each other column contains the data from one sample. You can use \link{absorbance_read} to read in appropriate data.

The following spectral parameters are calculated:
\itemize{
   \item $S_{275-295}$ slope between 275 and 295 nm calculated with nonlinear regression
   \item $S_{350-400}$ slope between 350 and 400 nm calculated with nonlinear regression
   \item $S_{300-700}$ slope between 275 and 295 nm calculated with nonlinear regression
   \item SR slope ratio, calculated by $S_{275-295}$/$S_{350-400}$
   \item E2:E3 ratio $a_{250}$/$a_{365}$
   \item E4:E6 ratio $a_{465}$/$a_{665}$
   \item $a_{254}$ absorbance at 254 nm
   \item $a_{300}$ absorbance at 300 nm
   }
Depending on available wavelength range, values might be NA.
Additionally other wavelength limits can be defined. The slope ratio might fail in this case.
For further details please refer to Helm et al. (2008).
}
\examples{
\donttest{
data(abs_data)
abs_parms(abs_data[,1:5],5)
abs_parms(abs_data[,1:5],5,l_ref=list(NA,NA,NA), lref=TRUE) # fit lref as well
}
}
\references{
Helms, J., Kieber, D., Mopper, K. 2008. Absorption spectral slopes and slope ratios as indicators of molecular weight, source, and photobleaching of chromophoric dissolved organic matter. Limnol. Oceanogr., 53(3), 955–969
\url{http://onlinelibrary.wiley.com/doi/10.4319/lo.2008.53.3.0955/pdf}
}
