% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_dummy.R
\name{na.dummy}
\alias{na.dummy}
\alias{fix_predvars}
\title{Handle Missing Values with Fill + Dummy}
\usage{
na.dummy(object, ...)

fix_predvars(object)
}
\arguments{
\item{object}{an R object, typically a data.frame}

\item{...}{other arguments (not used)}
}
\description{
Handles missing values by filling in with mean, and adding a dummy variable.
}
\examples{

df <- structure(list(Y = c(3.83, 22.73, 13.85, 14.09, 20.55, 18.51, 
17.76, 9.42, 15.88, 27.81), X1 = 1:10, X2 = c(2L, NA, NA, 4L, 
8L, 7L, 6L, 1L, 3L, 9L)), .Names = c("Y", "X1", "X2"), row.names = c(NA, 
-10L), class = "data.frame")

(m <- lm(Y~X1+X2, df, na.action = na.dummy))
m2 <- fix_predvars(m)
attr(terms(m2), "predvars")
predict(m2, newdata = data.frame(X1=2,X2=NA_real_))

}
\references{
\url{https://stackoverflow.com/questions/54642599/impute-constant-and-create-missingness-dummy/54757973#54757973}
}
\author{
\href{https://stackoverflow.com/users/986793/neal-fultz}{Neal Fultz}
}
