% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMXStanFit.R
\name{traces}
\alias{traces}
\title{Generation of trace plots of the samples}
\usage{
traces(fit, pars = NULL)
}
\arguments{
\item{fit}{a \code{PMXStanFit} object.}

\item{pars}{specifies names of parameters whose traces will be plotted. When it is not specified, 
the function by default plots all the \code{theta}'s (model parameters), \code{sigma_eta}'s 
(variance of the inter-individual random effects), and \code{sigma} (variance of the intra-individual
random effects) in the auto-generated Stan code.}
}
\description{
Plots traces of samples corresponding to one or more Markov chains during the sampling procedure with 
\code{Stan}. This is a generic version of the method \code{plot.trace()} for the \code{\link{PMXStanFit}} 
class.
}
\value{No return value, called for side effects}
\examples{
\donttest{
m1 <- PMXStanModel(path = tempfile("pk_m1"), pk.struct = "1-cmpt", compile=TRUE)

data("examples_data")
dat <- prepareInputData(data.source = d1_nm_poppk, model = m1)
fit <- PMXStanFit(m1, dat, iter=100, chains=1)

fit$plot.trace()
traces(fit)

fit$plot.trace(pars = c("CL", "V", "sigma"))
traces(fit, pars = c("CL", "V", "sigma"))
}
}
\seealso{
\code{\link{PMXStanFit}} for the method \code{plot.trace()}; \code{\link[rstan]{traceplot}} for a similar
implementation of plotting traces in \code{rstan}.
}

