% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constellation_incremental_refresh.R
\name{incremental_refresh_constellation}
\alias{incremental_refresh_constellation}
\alias{incremental_refresh_constellation.constellation}
\title{Incrementally refresh a constellation with a star schema}
\usage{
incremental_refresh_constellation(ct, st, existing = "ignore")

\method{incremental_refresh_constellation}{constellation}(ct, st, existing = "ignore")
}
\arguments{
\item{ct}{A \code{constellation} object.}

\item{st}{A \code{star_schema} object.}

\item{existing}{A string, operation to be performed with records in the fact
table whose keys match.}
}
\value{
A \code{constellation} object.
}
\description{
Incrementally refresh a star schema in a constellation with the content of a
new star schema that is integrated into the first.
}
\details{
Once the dimensions are integrated, if there are records in the fact table
whose keys match the new ones, new ones can be ignored, they can be replaced
by new ones, all of them can be grouped using the aggregation functions, or
they can be deleted. Therefore, the possible values of the \code{existing}
parameter are: "ignore", "replace", "group" or "delete".
}
\examples{
library(tidyr)

ct <- ct_mrs \%>\%
  incremental_refresh_constellation(st_mrs_age_w10, existing = "replace")

ct <- ct_mrs \%>\%
  incremental_refresh_constellation(st_mrs_cause_w10, existing = "group")

}
\seealso{


Other incremental refresh functions: 
\code{\link{filter_fact_rows}()},
\code{\link{get_star_schema_names}()},
\code{\link{get_star_schema}()},
\code{\link{incremental_refresh_star_schema}()},
\code{\link{purge_dimensions_constellation}()},
\code{\link{purge_dimensions_star_schema}()}
}
\concept{incremental refresh functions}
