% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_rename.R
\name{rename_dimension_attributes}
\alias{rename_dimension_attributes}
\alias{rename_dimension_attributes.star_schema}
\title{Rename dimension attributes}
\usage{
rename_dimension_attributes(st, name, attributes, new_names)

\method{rename_dimension_attributes}{star_schema}(st, name, attributes, new_names)
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{name}{A string, name of the dimension.}

\item{attributes}{A vector of attribute names.}

\item{new_names}{A vector of new attribute names.}
}
\value{
A \code{star_schema} object.
}
\description{
Set new names of some attributes in a dimension.
}
\examples{
library(tidyr)

st <-
  st_mrs_age \%>\% rename_dimension_attributes(
    name = "when",
    attributes = c("week", "year"),
    new_names = c("w", "y")
  )

}
\seealso{


Other rename functions: 
\code{\link{get_dimension_attribute_names}()},
\code{\link{get_measure_names}()},
\code{\link{rename_dimension}()},
\code{\link{rename_fact}()},
\code{\link{rename_measures}()}
}
\concept{rename functions}
