% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{st_mrs_cause}
\alias{st_mrs_cause}
\title{Star Schema for Mortality Reporting System by Cause}
\format{
A \code{star_schema} object.
}
\usage{
st_mrs_cause
}
\description{
Star Schema for the Mortality Reporting System considering the cause
classification.
}
\examples{
# Defined by:

library(tidyr)

st_mrs_cause <- star_schema(mrs_cause, dm_mrs_cause) \%>\%
  snake_case() \%>\%
  character_dimensions(
    NA_replacement_value = "Unknown",
    length_integers = list(
      week = 2,
      data_availability_week = 2,
      reception_week = 2
    )
  ) \%>\%
  role_playing_dimension(
    dim_names = c("when", "when_received", "when_available"),
    name = "when_common",
    attributes = c("date", "week", "year")
  )

}
\keyword{datasets}
