% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step.R
\name{Step}
\alias{Step}
\title{Define the operation applied on declared data.}
\usage{
Step(
  fun,
  target_dims,
  output_dims,
  use_libraries = NULL,
  use_attributes = NULL
)
}
\arguments{
\item{fun}{A function in R format defining the operation to be applied to the 
data declared by a Start() call. It should only work on the essential 
dimensions rather than all the data dimensions. Since the function will be
called numerous times through all the non-essential dimensions, it is 
recommended to keep them as light as possible.}

\item{target_dims}{A vector for single input array or a list of vectors for 
multiple input arrays indicating the names of the dimensions 'fun' to be 
applied along.}

\item{output_dims}{A vector for single returned array or a list of vectors 
for multiple returned arrays indicating the dimension names of the function
output.}

\item{use_libraries}{A vector of character string indicating the R library 
names to be used in 'fun'. The default value is NULL.}

\item{use_attributes}{One or more lists of vectors of character string 
indicating the data attributes to be used in 'fun'. The list name should be
consistent with the list name of 'data' in AddStep(). The default value is 
NULL.}
}
\value{
A closure that contains all the objects assigned. It serves as the
 input of Addstep().
}
\description{
The step of the startR workflow after declaring data by Start() call. It 
identifies the operation (i.e., function) and the target and output 
dimensions of data array for the function. Ideally, it expects the dimension
name to be in the same order as the one requested in the Start() call. 
If a different order is specified, startR will reorder the subset dimension 
to the expected order for this function.
}
\examples{
 data_path <- system.file('extdata', package = 'startR')
 path_obs <- file.path(data_path, 'obs/monthly_mean/$var$/$var$_$sdate$.nc')
 sdates <- c('200011', '200012')
 data <- Start(dat = list(list(path = path_obs)),
               var = 'tos',
               sdate = sdates,
               time = 'all',
               latitude = 'all',
               longitude = 'all',
               return_vars = list(latitude = 'dat', 
                                  longitude = 'dat', 
                                  time = 'sdate'),
               retrieve = FALSE)
 fun <- function(x) {
           lat = attributes(x)$Variables$dat1$latitude
           weight = sqrt(cos(lat * pi / 180))
           corrected = Apply(list(x), target_dims = "latitude",
                             fun = function(x) {x * weight})
         }
 step <- Step(fun = fun,
              target_dims = 'latitude',
              output_dims = 'latitude',
              use_libraries = c('multiApply'),
              use_attributes = list(data = "Variables"))
 wf <- AddStep(data, step)

}
