% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_atree.R
\name{panel_atree}
\alias{panel_atree}
\title{Create the elimination tree plot with some options in the config file}
\usage{
panel_atree(
  data = NULL,
  step = data$config$atree$step,
  legend = data$config$atree$legend,
  zoom = FALSE,
  computation = data$config$atree$computation$active,
  pruned = data$config$atree$computation$pruned$active,
  initialization = data$config$atree$initialization$active,
  x_start = data$config$limits$start,
  x_end = data$config$limits$end,
  communication = data$config$atree$communication$active,
  anomalies = data$config$atree$anomalies$active,
  performance_metric = "time",
  level = 0,
  end_arrow = "ParentEnd"
)
}
\arguments{
\item{data}{starvz_data with trace data}

\item{step}{size in milliseconds for the time aggregation step}

\item{legend}{enable/disable panel legend}

\item{zoom}{enable/disable vertical zoom in the tree structure}

\item{computation}{enable/disable computations representations in the tree}

\item{pruned}{enable/disable pruned computations representations in the tree}

\item{initialization}{enable/disable initialization tasks representation}

\item{x_start}{X-axis start value}

\item{x_end}{X-axis end value}

\item{communication}{enable/disable communication tasks representation}

\item{anomalies}{enable/disable anomalies tasks representation}

\item{performance_metric}{which metric to represent ["time", "gflops"]}

\item{level}{draw a dashed line to divide the tree at the level h}

\item{end_arrow}{behavior of the end arrow [ParentEnd, ComputationEnd]}
}
\value{
A ggplot object
}
\description{
Use starvz_data to create a representation of the elimination tree structure
considering initialization, communication, and computational tasks. These
representations can be controlled in the configuration file.
}
\examples{
\dontrun{
panel_atree(starvz_sample_lu, step = 10)
panel_atree(starvz_sample_lu, step = 20,
            communication = FALSE, initialization = FALSE)
}
}
