% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createVarComp.R
\name{CRDR}
\alias{CRDR}
\title{Calculate the correlated response to selection}
\usage{
CRDR(varComp)
}
\arguments{
\item{varComp}{An object of class varComp.}
}
\description{
Calculate the correlated response to selection (CRDR) based on the fitted
model. The CRDR is calculated as described by Atlin et al. E.g. for a model
with trials nested within scenarios, which has a random part that looks like
this: genotype + genotype:scenario + genotype:scenario:trial the CRDR is
calculated as:\cr\cr
\deqn{H1 = \sigma_G^2 / (\sigma_G^2 + \sigma_S^2 / s + \sigma_{ST}^2 / st +
\sigma_E^2 / str)}
\deqn{H2 = (\sigma_G^2 + \sigma_S^2) / (\sigma_G^2 + \sigma_S^2 +
\sigma_{ST}^2 / st + \sigma_E^2 / str)}
\deqn{CRDR = (\sigma_G^2 / (\sigma_G^2 + \sigma_S^2)) * sqrt(H1 / H2)}
In these formulas the \eqn{\sigma} terms stand for the standard deviations of
the respective model terms, and the lower case letters for the number of
levels for the respective model terms. So \eqn{\sigma_S} is the standard
deviation for the scenario term in the model and \eqn{s} is the number of
scenarios. \eqn{\sigma_E} corresponds to the residual standard deviation and
\eqn{r} to the number of replicates.
}
\references{
Atlin, G. N., Baker, R. J., McRae, K. B., & Lu, X. (2000).
Selection response in subdivided target regions. Crop Science, 40(1), 7–13.
\url{https://doi.org/10.2135/cropsci2000.4017}
}
\seealso{
Other Mixed model analysis: 
\code{\link{correlations}()},
\code{\link{diagnostics}()},
\code{\link{gxeVarComp}()},
\code{\link{herit}()},
\code{\link{plot.varComp}()},
\code{\link{predict.varComp}()},
\code{\link{vc}()}
}
\concept{Mixed model analysis}
