% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.biphi}
\alias{size.ci.biphi}
\title{Sample size for biserial-phi correlation confidence interval}
\usage{
size.ci.biphi(alpha, p1, p2, cor, w)
}
\arguments{
\item{alpha}{alpha level for 1 - alpha confidence}

\item{p1}{planning value for row 1 marginal proportion}

\item{p2}{planning value for column 1 marginal proportion}

\item{cor}{planning value for biserial-phi correlation}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a biserial-phi correlation
with desired confidence interval precision. Set the biserial-phi planning
value to the smallest absolute value within a plausible range for a
conservatively large sample size. The column variable is assumed to be
naturally dichotomous and the row variable is assumed to be artificially
dichotomous.
}
\examples{
size.ci.biphi(.05, .2, .5, .3, .4)

# Should return:
#  Sample size
#          195


}
