% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixer_functions.R
\name{fix_time}
\alias{fix_time}
\title{Fixes the time column of a data set}
\usage{
fix_time(date_string, as_char = FALSE)
}
\arguments{
\item{date_string}{a string of dates formatted as months or quarters.}

\item{as_char}{whether to return the dates as data objects or character strings.}
}
\value{
a data frame
}
\description{
Statistics Denmark data often come with times/dates that are formatted to
fit months or quarters. This function converts them in to proper date strings
in the format YYYY-MM-DD.
}
\examples{
df <- statsDK::retrieve_data("FOLK1A", TID = "*", ALDER = "IALT",
                             CIVILSTAND = "TOT", lang = "da")
dplyr::glimpse(df)

df$TID <- statsDK::fix_time(df$TID)
dplyr::glimpse(df)

}
