% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.r
\name{gvoter}
\alias{gvoter}
\title{Get the vote information of given IDs from SteemSQL. gvoter means 'get the voter activities.'}
\usage{
gvoter(voters = NA, from = Sys.Date() - 7, to = Sys.Date(), select = "*", sql_con = NA, 
    if_plot = FALSE)
}
\arguments{
\item{voters}{A character vector of given Steem IDs.}

\item{from}{A character string of the starting date. in 'Y-m-d' format.}

\item{to}{A character string of the ending date. in 'Y-m-d' format.}

\item{select}{A character vector of the selected columns in the SteemSQL query.}

\item{sql_con}{A connection to the SteemSQL server.}

\item{if_plot}{A logic value of whether plot the daily votes.}
}
\value{
A list (and a diagram) of the voter report.
}
\description{
Get the vote information of given IDs from SteemSQL. gvoter means 'get the voter activities.'
}
\examples{
\dontrun{
gvoter(voters = NA)
}
}
