% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{get_coefs}
\alias{get_coefs}
\title{Extract reported parameter estimates}
\usage{
get_coefs(obj)
}
\arguments{
\item{obj}{A fitted model as returned by one of  \code{\link{fit_hawkes}}, \code{\link{fit_hawkes_cbf}}, \code{\link{fit_lgcp}},  \code{\link{fit_mlgcp}}, or \code{\link{fit_stelfi}}.}
}
\value{
A matrix of estimated parameters and standard errors returned by
\code{TMB::sdreport} (\code{"report"}).
}
\description{
Return parameter estimates from a fitted model.
}
\examples{
## Hawkes
data(retweets_niwa, package = "stelfi")
times <- unique(sort(as.numeric(difftime(retweets_niwa, min(retweets_niwa),units = "mins"))))
params <- c(mu = 9, alpha = 3, beta = 10)
fit <- fit_hawkes(times = times, parameters = params)
get_coefs(fit)
## LGCP
if(requireNamespace("INLA")) {
data(xyt, package = "stelfi")
domain <- sf::st_as_sf(xyt$window)
locs <- data.frame(x = xyt$x, y = xyt$y)
bnd <- INLA::inla.mesh.segment(as.matrix(sf::st_coordinates(domain)[, 1:2]))
smesh <- INLA::inla.mesh.2d(boundary = bnd, max.edge = 0.75, cutoff = 0.3)
fit <- fit_lgcp(locs = locs, sf = domain, smesh = smesh,
parameters = c(beta = 0, log_tau = log(1), log_kappa = log(1)))
get_coefs(fit)
}
}
\seealso{
\code{\link{fit_hawkes}},  \code{\link{fit_hawkes_cbf}}, \code{\link{fit_lgcp}},  \code{\link{fit_mlgcp}}, and \code{\link{fit_stelfi}}
}
