% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.r
\name{show_lambda}
\alias{show_lambda}
\title{Plot the estimated intensity from a fitted LGCP model}
\usage{
show_lambda(
  obj,
  smesh,
  sf,
  tmesh,
  covariates,
  clip = FALSE,
  dims = c(500, 500),
  timestamp = 1
)
}
\arguments{
\item{obj}{A fitted LGCP model object for, for example, \code{fit_lgcp()}.}

\item{smesh}{A Delaunay triangulation of the spatial domain returned by \code{INLA::inla.mesh.2d()}.}

\item{sf}{An \code{sf} of type \code{POLYGON} specifying the spatial region
of the domain.}

\item{tmesh}{Optional, a temporal mesh returned by \code{INLA::inla.mesh.1d()}.}

\item{covariates}{Optional, a \code{matrix} of covariates at each
\code{smesh} and \code{tmesh} node combination.}

\item{clip}{Logical, if \code{TRUE} then plotted values are `clipped` to the domain
supplied as \code{sf}.}

\item{dims}{A numeric vector of length 2 specifying
the spatial pixel resolution. Default \code{c(500,500)}.}

\item{timestamp}{The index of time stamp to plot. Default \code{1}.}
}
\value{
A \code{gg} class object, values returned by \code{geom_tile} and \code{geom_sf}.
}
\description{
Plots the estimated spatial intensity from
a fitted log-Gaussian Cox process model. If \code{obj} is a
spatiotemporal model then \code{timestamp} provides control
over which temporal index to plot the estimated spatial intensity.
}
\examples{
\donttest{
if(requireNamespace("INLA")) {
data(xyt, package = "stelfi")
domain <- sf::st_as_sf(xyt$window)
locs <- data.frame(x = xyt$x, y = xyt$y)
bnd <- INLA::inla.mesh.segment(as.matrix(sf::st_coordinates(domain)[, 1:2]))
smesh <- INLA::inla.mesh.2d(boundary = bnd, max.edge = 0.75, cutoff = 0.3)
fit <- fit_lgcp(locs = locs, sf = domain, smesh = smesh,
parameters = c(beta = 0, log_tau = log(1), log_kappa = log(1)))
show_lambda(fit, smesh = smesh, sf = domain)
}
}
}
\seealso{
\code{\link{fit_lgcp}}, \code{\link{show_field}}, and \code{\link{get_fields}}
}
