% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbayesboot.R
\name{sbayesboot}
\alias{sbayesboot}
\title{Bootstrap a Regression Model, the Bayesian Way}
\usage{
sbayesboot(object, reps = 1000L, seed, cluster = NULL, ...)
}
\arguments{
\item{object}{a regression model object}

\item{reps}{how many bootstrap replicates the user wants. Defaults to 1000}

\item{seed}{set an optional seed for reproducibility}

\item{cluster}{an optional cluster for calibrating the weights}

\item{...}{optional arguments}
}
\value{
\code{sbayesboot()} takes a fitted regression model and returns a matrix
of bootstrapped coefficients (with intercept). These could be easily
converted to a data frame for ease of summary.
}
\description{
\code{sbayesboot()} performs a Bayesian bootstrap of a regression model.
}
\details{
The code underpinning \code{sbayesboot()} is largely derived from
code provided by Grant McDermott and Vincent Arel-Bundock. My approach here
takes the flexibility of McDermott's model-agnostic code (along with the
ease of specifying clusters) and combines it with Arel-Bundock's
\code{update()} approach to the actual bootstrapping. I may have screwed
something up, so feel free to point to cases where I did screw up.
}
\examples{
\donttest{
M1 <- lm(mpg ~ disp + wt + hp, mtcars)

# Default options

BB1 <- sbayesboot(M1)

# Cluster bootstrap on cylinder variable

BB2 <- sbayesboot(M1, cluster=~cyl)
}
}
\author{
Grant McDermott, Vincent Arel-Bundock
}
