% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{ForestSamples}
\alias{ForestSamples}
\title{Class that stores draws from an random ensemble of decision trees}
\description{
Wrapper around a C++ container of tree ensembles
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{forest_container_ptr}}{External pointer to a C++ ForestContainer class}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ForestSamples-new}{\code{ForestSamples$new()}}
\item \href{#method-ForestSamples-load_from_json}{\code{ForestSamples$load_from_json()}}
\item \href{#method-ForestSamples-append_from_json}{\code{ForestSamples$append_from_json()}}
\item \href{#method-ForestSamples-load_from_json_string}{\code{ForestSamples$load_from_json_string()}}
\item \href{#method-ForestSamples-append_from_json_string}{\code{ForestSamples$append_from_json_string()}}
\item \href{#method-ForestSamples-predict}{\code{ForestSamples$predict()}}
\item \href{#method-ForestSamples-predict_raw}{\code{ForestSamples$predict_raw()}}
\item \href{#method-ForestSamples-predict_raw_single_forest}{\code{ForestSamples$predict_raw_single_forest()}}
\item \href{#method-ForestSamples-predict_raw_single_tree}{\code{ForestSamples$predict_raw_single_tree()}}
\item \href{#method-ForestSamples-set_root_leaves}{\code{ForestSamples$set_root_leaves()}}
\item \href{#method-ForestSamples-prepare_for_sampler}{\code{ForestSamples$prepare_for_sampler()}}
\item \href{#method-ForestSamples-adjust_residual}{\code{ForestSamples$adjust_residual()}}
\item \href{#method-ForestSamples-save_json}{\code{ForestSamples$save_json()}}
\item \href{#method-ForestSamples-load_json}{\code{ForestSamples$load_json()}}
\item \href{#method-ForestSamples-num_samples}{\code{ForestSamples$num_samples()}}
\item \href{#method-ForestSamples-num_trees}{\code{ForestSamples$num_trees()}}
\item \href{#method-ForestSamples-leaf_dimension}{\code{ForestSamples$leaf_dimension()}}
\item \href{#method-ForestSamples-is_constant_leaf}{\code{ForestSamples$is_constant_leaf()}}
\item \href{#method-ForestSamples-is_exponentiated}{\code{ForestSamples$is_exponentiated()}}
\item \href{#method-ForestSamples-add_forest_with_constant_leaves}{\code{ForestSamples$add_forest_with_constant_leaves()}}
\item \href{#method-ForestSamples-add_numeric_split_tree}{\code{ForestSamples$add_numeric_split_tree()}}
\item \href{#method-ForestSamples-get_tree_leaves}{\code{ForestSamples$get_tree_leaves()}}
\item \href{#method-ForestSamples-get_tree_split_counts}{\code{ForestSamples$get_tree_split_counts()}}
\item \href{#method-ForestSamples-get_forest_split_counts}{\code{ForestSamples$get_forest_split_counts()}}
\item \href{#method-ForestSamples-get_aggregate_split_counts}{\code{ForestSamples$get_aggregate_split_counts()}}
\item \href{#method-ForestSamples-get_granular_split_counts}{\code{ForestSamples$get_granular_split_counts()}}
\item \href{#method-ForestSamples-ensemble_tree_max_depth}{\code{ForestSamples$ensemble_tree_max_depth()}}
\item \href{#method-ForestSamples-average_ensemble_max_depth}{\code{ForestSamples$average_ensemble_max_depth()}}
\item \href{#method-ForestSamples-average_max_depth}{\code{ForestSamples$average_max_depth()}}
\item \href{#method-ForestSamples-num_forest_leaves}{\code{ForestSamples$num_forest_leaves()}}
\item \href{#method-ForestSamples-sum_leaves_squared}{\code{ForestSamples$sum_leaves_squared()}}
\item \href{#method-ForestSamples-is_leaf_node}{\code{ForestSamples$is_leaf_node()}}
\item \href{#method-ForestSamples-is_numeric_split_node}{\code{ForestSamples$is_numeric_split_node()}}
\item \href{#method-ForestSamples-is_categorical_split_node}{\code{ForestSamples$is_categorical_split_node()}}
\item \href{#method-ForestSamples-parent_node}{\code{ForestSamples$parent_node()}}
\item \href{#method-ForestSamples-left_child_node}{\code{ForestSamples$left_child_node()}}
\item \href{#method-ForestSamples-right_child_node}{\code{ForestSamples$right_child_node()}}
\item \href{#method-ForestSamples-node_depth}{\code{ForestSamples$node_depth()}}
\item \href{#method-ForestSamples-node_split_index}{\code{ForestSamples$node_split_index()}}
\item \href{#method-ForestSamples-node_split_threshold}{\code{ForestSamples$node_split_threshold()}}
\item \href{#method-ForestSamples-node_split_categories}{\code{ForestSamples$node_split_categories()}}
\item \href{#method-ForestSamples-node_leaf_values}{\code{ForestSamples$node_leaf_values()}}
\item \href{#method-ForestSamples-num_nodes}{\code{ForestSamples$num_nodes()}}
\item \href{#method-ForestSamples-num_leaves}{\code{ForestSamples$num_leaves()}}
\item \href{#method-ForestSamples-num_leaf_parents}{\code{ForestSamples$num_leaf_parents()}}
\item \href{#method-ForestSamples-num_split_nodes}{\code{ForestSamples$num_split_nodes()}}
\item \href{#method-ForestSamples-nodes}{\code{ForestSamples$nodes()}}
\item \href{#method-ForestSamples-leaves}{\code{ForestSamples$leaves()}}
\item \href{#method-ForestSamples-delete_sample}{\code{ForestSamples$delete_sample()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-new"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-new}{}}}
\subsection{Method \code{new()}}{
Create a new ForestContainer object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$new(
  num_trees,
  leaf_dimension = 1,
  is_leaf_constant = FALSE,
  is_exponentiated = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_trees}}{Number of trees}

\item{\code{leaf_dimension}}{Dimensionality of the outcome model}

\item{\code{is_leaf_constant}}{Whether leaf is constant}

\item{\code{is_exponentiated}}{Whether forest predictions should be exponentiated before being returned}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ForestContainer} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-load_from_json"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-load_from_json}{}}}
\subsection{Method \code{load_from_json()}}{
Create a new \code{ForestContainer} object from a json object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$load_from_json(json_object, json_forest_label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_object}}{Object of class \code{CppJson}}

\item{\code{json_forest_label}}{Label referring to a particular forest (i.e. "forest_0") in the overall json hierarchy}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ForestContainer} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-append_from_json"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-append_from_json}{}}}
\subsection{Method \code{append_from_json()}}{
Append to a \code{ForestContainer} object from a json object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$append_from_json(json_object, json_forest_label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_object}}{Object of class \code{CppJson}}

\item{\code{json_forest_label}}{Label referring to a particular forest (i.e. "forest_0") in the overall json hierarchy}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-load_from_json_string"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-load_from_json_string}{}}}
\subsection{Method \code{load_from_json_string()}}{
Create a new \code{ForestContainer} object from a json object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$load_from_json_string(json_string, json_forest_label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_string}}{JSON string which parses into object of class \code{CppJson}}

\item{\code{json_forest_label}}{Label referring to a particular forest (i.e. "forest_0") in the overall json hierarchy}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ForestContainer} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-append_from_json_string"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-append_from_json_string}{}}}
\subsection{Method \code{append_from_json_string()}}{
Append to a \code{ForestContainer} object from a json object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$append_from_json_string(json_string, json_forest_label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_string}}{JSON string which parses into object of class \code{CppJson}}

\item{\code{json_forest_label}}{Label referring to a particular forest (i.e. "forest_0") in the overall json hierarchy}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-predict"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-predict}{}}}
\subsection{Method \code{predict()}}{
Predict every tree ensemble on every sample in \code{forest_dataset}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$predict(forest_dataset)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_dataset}}{\code{ForestDataset} R class}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
matrix of predictions with as many rows as in forest_dataset
and as many columns as samples in the \code{ForestContainer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-predict_raw"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-predict_raw}{}}}
\subsection{Method \code{predict_raw()}}{
Predict "raw" leaf values (without being multiplied by basis) for every tree ensemble on every sample in \code{forest_dataset}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$predict_raw(forest_dataset)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_dataset}}{\code{ForestDataset} R class}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Array of predictions for each observation in \code{forest_dataset} and
each sample in the \code{ForestSamples} class with each prediction having the
dimensionality of the forests' leaf model. In the case of a constant leaf model
or univariate leaf regression, this array is two-dimensional (number of observations,
number of forest samples). In the case of a multivariate leaf regression,
this array is three-dimension (number of observations, leaf model dimension,
number of samples).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-predict_raw_single_forest"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-predict_raw_single_forest}{}}}
\subsection{Method \code{predict_raw_single_forest()}}{
Predict "raw" leaf values (without being multiplied by basis) for a specific forest on every sample in \code{forest_dataset}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$predict_raw_single_forest(forest_dataset, forest_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_dataset}}{\code{ForestDataset} R class}

\item{\code{forest_num}}{Index of the forest sample within the container}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
matrix of predictions with as many rows as in forest_dataset
and as many columns as dimensions in the leaves of trees in \code{ForestContainer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-predict_raw_single_tree"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-predict_raw_single_tree}{}}}
\subsection{Method \code{predict_raw_single_tree()}}{
Predict "raw" leaf values (without being multiplied by basis) for a specific tree in a specific forest on every observation in \code{forest_dataset}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$predict_raw_single_tree(forest_dataset, forest_num, tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_dataset}}{\code{ForestDataset} R class}

\item{\code{forest_num}}{Index of the forest sample within the container}

\item{\code{tree_num}}{Index of the tree to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
matrix of predictions with as many rows as in \code{forest_dataset}
and as many columns as dimensions in the leaves of trees in \code{ForestContainer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-set_root_leaves"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-set_root_leaves}{}}}
\subsection{Method \code{set_root_leaves()}}{
Set a constant predicted value for every tree in the ensemble.
Stops program if any tree is more than a root node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$set_root_leaves(forest_num, leaf_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest sample within the container.}

\item{\code{leaf_value}}{Constant leaf value(s) to be fixed for each tree in the ensemble indexed by \code{forest_num}. Can be either a single number or a vector, depending on the forest's leaf dimension.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-prepare_for_sampler"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-prepare_for_sampler}{}}}
\subsection{Method \code{prepare_for_sampler()}}{
Set a constant predicted value for every tree in the ensemble.
Stops program if any tree is more than a root node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$prepare_for_sampler(
  dataset,
  outcome,
  forest_model,
  leaf_model_int,
  leaf_value
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{\code{ForestDataset} Dataset class (covariates, basis, etc...)}

\item{\code{outcome}}{\code{Outcome} Outcome class (residual / partial residual)}

\item{\code{forest_model}}{\code{ForestModel} object storing tracking structures used in training / sampling}

\item{\code{leaf_model_int}}{Integer value encoding the leaf model type (0 = constant gaussian, 1 = univariate gaussian, 2 = multivariate gaussian, 3 = log linear variance).}

\item{\code{leaf_value}}{Constant leaf value(s) to be fixed for each tree in the ensemble indexed by \code{forest_num}. Can be either a single number or a vector, depending on the forest's leaf dimension.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-adjust_residual"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-adjust_residual}{}}}
\subsection{Method \code{adjust_residual()}}{
Adjusts residual based on the predictions of a forest

This is typically run just once at the beginning of a forest sampling algorithm.
After trees are initialized with constant root node predictions, their root predictions are subtracted out of the residual.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$adjust_residual(
  dataset,
  outcome,
  forest_model,
  requires_basis,
  forest_num,
  add
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{\code{ForestDataset} object storing the covariates and bases for a given forest}

\item{\code{outcome}}{\code{Outcome} object storing the residuals to be updated based on forest predictions}

\item{\code{forest_model}}{\code{ForestModel} object storing tracking structures used in training / sampling}

\item{\code{requires_basis}}{Whether or not a forest requires a basis for prediction}

\item{\code{forest_num}}{Index of forest used to update residuals}

\item{\code{add}}{Whether forest predictions should be added to or subtracted from residuals}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-save_json"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-save_json}{}}}
\subsection{Method \code{save_json()}}{
Store the trees and metadata of \code{ForestDataset} class in a json file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$save_json(json_filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_filename}}{Name of output json file (must end in ".json")}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-load_json"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-load_json}{}}}
\subsection{Method \code{load_json()}}{
Load trees and metadata for an ensemble from a json file. Note that
any trees and metadata already present in \code{ForestDataset} class will
be overwritten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$load_json(json_filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_filename}}{Name of model input json file (must end in ".json")}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-num_samples"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-num_samples}{}}}
\subsection{Method \code{num_samples()}}{
Return number of samples in a \code{ForestContainer} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$num_samples()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Sample count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-num_trees"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-num_trees}{}}}
\subsection{Method \code{num_trees()}}{
Return number of trees in each ensemble of a \code{ForestContainer} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$num_trees()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Tree count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-leaf_dimension"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-leaf_dimension}{}}}
\subsection{Method \code{leaf_dimension()}}{
Return output dimension of trees in a \code{ForestContainer} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$leaf_dimension()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Leaf node parameter size
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-is_constant_leaf"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-is_constant_leaf}{}}}
\subsection{Method \code{is_constant_leaf()}}{
Return constant leaf status of trees in a \code{ForestContainer} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$is_constant_leaf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if leaves are constant, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-is_exponentiated"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-is_exponentiated}{}}}
\subsection{Method \code{is_exponentiated()}}{
Return exponentiation status of trees in a \code{ForestContainer} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$is_exponentiated()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if leaf predictions must be exponentiated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-add_forest_with_constant_leaves"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-add_forest_with_constant_leaves}{}}}
\subsection{Method \code{add_forest_with_constant_leaves()}}{
Add a new all-root ensemble to the container, with all of the leaves
set to the value / vector provided
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$add_forest_with_constant_leaves(leaf_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leaf_value}}{Value (or vector of values) to initialize root nodes in tree}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-add_numeric_split_tree"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-add_numeric_split_tree}{}}}
\subsection{Method \code{add_numeric_split_tree()}}{
Add a numeric (i.e. \code{X[,i] <= c}) split to a given tree in the ensemble
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$add_numeric_split_tree(
  forest_num,
  tree_num,
  leaf_num,
  feature_num,
  split_threshold,
  left_leaf_value,
  right_leaf_value
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest which contains the tree to be split}

\item{\code{tree_num}}{Index of the tree to be split}

\item{\code{leaf_num}}{Leaf to be split}

\item{\code{feature_num}}{Feature that defines the new split}

\item{\code{split_threshold}}{Value that defines the cutoff of the new split}

\item{\code{left_leaf_value}}{Value (or vector of values) to assign to the newly created left node}

\item{\code{right_leaf_value}}{Value (or vector of values) to assign to the newly created right node}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-get_tree_leaves"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-get_tree_leaves}{}}}
\subsection{Method \code{get_tree_leaves()}}{
Retrieve a vector of indices of leaf nodes for a given tree in a given forest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$get_tree_leaves(forest_num, tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest which contains tree \code{tree_num}}

\item{\code{tree_num}}{Index of the tree for which leaf indices will be retrieved}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-get_tree_split_counts"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-get_tree_split_counts}{}}}
\subsection{Method \code{get_tree_split_counts()}}{
Retrieve a vector of split counts for every training set variable in a given tree in a given forest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$get_tree_split_counts(forest_num, tree_num, num_features)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest which contains tree \code{tree_num}}

\item{\code{tree_num}}{Index of the tree for which split counts will be retrieved}

\item{\code{num_features}}{Total number of features in the training set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-get_forest_split_counts"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-get_forest_split_counts}{}}}
\subsection{Method \code{get_forest_split_counts()}}{
Retrieve a vector of split counts for every training set variable in a given forest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$get_forest_split_counts(forest_num, num_features)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest for which split counts will be retrieved}

\item{\code{num_features}}{Total number of features in the training set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-get_aggregate_split_counts"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-get_aggregate_split_counts}{}}}
\subsection{Method \code{get_aggregate_split_counts()}}{
Retrieve a vector of split counts for every training set variable in a given forest, aggregated across ensembles and trees
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$get_aggregate_split_counts(num_features)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_features}}{Total number of features in the training set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-get_granular_split_counts"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-get_granular_split_counts}{}}}
\subsection{Method \code{get_granular_split_counts()}}{
Retrieve a vector of split counts for every training set variable in a given forest, reported separately for each ensemble and tree
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$get_granular_split_counts(num_features)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_features}}{Total number of features in the training set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-ensemble_tree_max_depth"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-ensemble_tree_max_depth}{}}}
\subsection{Method \code{ensemble_tree_max_depth()}}{
Maximum depth of a specific tree in a specific ensemble in a \code{ForestSamples} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$ensemble_tree_max_depth(ensemble_num, tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ensemble_num}}{Ensemble number}

\item{\code{tree_num}}{Tree index within ensemble \code{ensemble_num}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Maximum leaf depth
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-average_ensemble_max_depth"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-average_ensemble_max_depth}{}}}
\subsection{Method \code{average_ensemble_max_depth()}}{
Average the maximum depth of each tree in a given ensemble in a \code{ForestSamples} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$average_ensemble_max_depth(ensemble_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ensemble_num}}{Ensemble number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Average maximum depth
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-average_max_depth"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-average_max_depth}{}}}
\subsection{Method \code{average_max_depth()}}{
Average the maximum depth of each tree in each ensemble in a \code{ForestContainer} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$average_max_depth()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Average maximum depth
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-num_forest_leaves"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-num_forest_leaves}{}}}
\subsection{Method \code{num_forest_leaves()}}{
Number of leaves in a given ensemble in a \code{ForestSamples} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$num_forest_leaves(forest_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the ensemble to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Count of leaves in the ensemble stored at \code{forest_num}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-sum_leaves_squared"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-sum_leaves_squared}{}}}
\subsection{Method \code{sum_leaves_squared()}}{
Sum of squared (raw) leaf values in a given ensemble in a \code{ForestSamples} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$sum_leaves_squared(forest_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the ensemble to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Average maximum depth
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-is_leaf_node"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-is_leaf_node}{}}}
\subsection{Method \code{is_leaf_node()}}{
Whether or not a given node of a given tree in a given forest in the \code{ForestSamples} is a leaf
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$is_leaf_node(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if node is a leaf, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-is_numeric_split_node"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-is_numeric_split_node}{}}}
\subsection{Method \code{is_numeric_split_node()}}{
Whether or not a given node of a given tree in a given forest in the \code{ForestSamples} is a numeric split node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$is_numeric_split_node(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if node is a numeric split node, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-is_categorical_split_node"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-is_categorical_split_node}{}}}
\subsection{Method \code{is_categorical_split_node()}}{
Whether or not a given node of a given tree in a given forest in the \code{ForestSamples} is a categorical split node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$is_categorical_split_node(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if node is a categorical split node, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-parent_node"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-parent_node}{}}}
\subsection{Method \code{parent_node()}}{
Parent node of given node of a given tree in a given forest in a \code{ForestSamples} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$parent_node(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer ID of the parent node
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-left_child_node"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-left_child_node}{}}}
\subsection{Method \code{left_child_node()}}{
Left child node of given node of a given tree in a given forest in a \code{ForestSamples} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$left_child_node(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer ID of the left child node
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-right_child_node"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-right_child_node}{}}}
\subsection{Method \code{right_child_node()}}{
Right child node of given node of a given tree in a given forest in a \code{ForestSamples} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$right_child_node(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer ID of the right child node
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-node_depth"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-node_depth}{}}}
\subsection{Method \code{node_depth()}}{
Depth of given node of a given tree in a given forest in a \code{ForestSamples} object, with 0 depth for the root node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$node_depth(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer valued depth of the node
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-node_split_index"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-node_split_index}{}}}
\subsection{Method \code{node_split_index()}}{
Split index of given node of a given tree in a given forest in a \code{ForestSamples} object. Returns \code{-1} is node is a leaf.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$node_split_index(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer valued depth of the node
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-node_split_threshold"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-node_split_threshold}{}}}
\subsection{Method \code{node_split_threshold()}}{
Threshold that defines a numeric split for a given node of a given tree in a given forest in a \code{ForestSamples} object.
Returns \code{Inf} if the node is a leaf or a categorical split node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$node_split_threshold(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Threshold defining a split for the node
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-node_split_categories"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-node_split_categories}{}}}
\subsection{Method \code{node_split_categories()}}{
Array of category indices that define a categorical split for a given node of a given tree in a given forest in a \code{ForestSamples} object.
Returns \code{c(Inf)} if the node is a leaf or a numeric split node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$node_split_categories(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Categories defining a split for the node
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-node_leaf_values"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-node_leaf_values}{}}}
\subsection{Method \code{node_leaf_values()}}{
Leaf node value(s) for a given node of a given tree in a given forest in a \code{ForestSamples} object.
Values are stale if the node is a split node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$node_leaf_values(forest_num, tree_num, node_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}

\item{\code{node_id}}{Index of the node to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector (often univariate) of leaf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-num_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-num_nodes}{}}}
\subsection{Method \code{num_nodes()}}{
Number of nodes in a given tree in a given forest in a \code{ForestSamples} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$num_nodes(forest_num, tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Count of total tree nodes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-num_leaves"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-num_leaves}{}}}
\subsection{Method \code{num_leaves()}}{
Number of leaves in a given tree in a given forest in a \code{ForestSamples} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$num_leaves(forest_num, tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Count of total tree leaves
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-num_leaf_parents"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-num_leaf_parents}{}}}
\subsection{Method \code{num_leaf_parents()}}{
Number of leaf parents (split nodes with two leaves as children) in a given tree in a given forest in a \code{ForestSamples} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$num_leaf_parents(forest_num, tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Count of total tree leaf parents
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-num_split_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-num_split_nodes}{}}}
\subsection{Method \code{num_split_nodes()}}{
Number of split nodes in a given tree in a given forest in a \code{ForestSamples} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$num_split_nodes(forest_num, tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Count of total tree split nodes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-nodes"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-nodes}{}}}
\subsection{Method \code{nodes()}}{
Array of node indices in a given tree in a given forest in a \code{ForestSamples} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$nodes(forest_num, tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Indices of tree nodes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-leaves"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-leaves}{}}}
\subsection{Method \code{leaves()}}{
Array of leaf indices in a given tree in a given forest in a \code{ForestSamples} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$leaves(forest_num, tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be queried}

\item{\code{tree_num}}{Index of the tree to be queried}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Indices of leaf nodes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestSamples-delete_sample"></a>}}
\if{latex}{\out{\hypertarget{method-ForestSamples-delete_sample}{}}}
\subsection{Method \code{delete_sample()}}{
Modify the \code{ForestSamples} object by removing the forest sample indexed by `forest_num
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestSamples$delete_sample(forest_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_num}}{Index of the forest to be removed}
}
\if{html}{\out{</div>}}
}
}
}
