% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_decisions.R
\name{get_session_decisions}
\alias{get_session_decisions}
\title{Retrieve all decisions for a specified session}
\usage{
get_session_decisions(sessionid = NA, good_manners = 0)
}
\arguments{
\item{sessionid}{Character string indicating the id of the session to request all votes from}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{session_id} \tab Session id \cr
   \strong{decision_id} \tab Decision id \cr
   \strong{case_id} \tab Case id \cr
   \strong{case_link_url} \tab URL for case to front end web page \cr
   \strong{decision_date} \tab Decision date \cr
   \strong{decision_link_url} \tab URL for decision to front end web page \cr
   \strong{decision_number} \tab Decision number within session \cr
   \strong{decision_text} \tab Decision text \cr
   \strong{decision_title} \tab Decision title \cr
   \strong{decision_type_id} \tab Decision type id \cr
   \strong{decision_type_name} \tab Decision type name \cr
}
}
\description{
A function for retrieving all decisions from a specific parliamentary session.
}
\examples{

\dontrun{

desci <- get_session_decisions("2004-2005")
head(desci)
}
 
}
\seealso{
\link{get_decision_votes}
}
