% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_projected.R
\name{geo_projected}
\alias{geo_projected}
\alias{gprojected}
\title{Perform GIS functions on a temporary, projected version of a spatial object}
\usage{
geo_projected(shp, fun, crs, silent, ...)
}
\arguments{
\item{shp}{A spatial object with a geographic (WGS84) coordinate system}

\item{fun}{A function to perform on the projected object (e.g. the the rgeos or sf packages)}

\item{crs}{An optional coordinate reference system (if not provided it is set
automatically by \code{\link{crs_select_aeq}})}

\item{silent}{A binary value for printing the CRS details (default: TRUE)}

\item{...}{Arguments to pass to \code{fun}, e.g. \code{byid = TRUE} if the function is \code{\link[rgeos]{gLength}}))}
}
\description{
This function performs operations on projected data.
}
\examples{
library(sf)
shp = routes_fast_sf[2:4,]
plot(geo_projected(shp, st_buffer, dist = 100)$geometry)
shp = sf::as_Spatial(shp$geometry)
geo_projected(shp, fun = rgeos::gBuffer, width = 100, byid = TRUE)
rlength = geo_projected(routes_fast, fun = rgeos::gLength, byid = TRUE)
plot(routes_fast$length, rlength)
}
