% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_coords2line}
\alias{od_coords2line}
\title{Convert origin-destination coordinates into desire lines}
\usage{
od_coords2line(odc, crs = sf::st_crs())
}
\arguments{
\item{odc}{A data frame or matrix of representing the coordinates
of origin-destination data. The first two columns represent the
coordinates of the origin (typically longitude and latitude) points;
the second two columns represent the coordinates of the destination
(in the same CRS). Each row represents travel from origin to destination.}

\item{crs}{A number representing the coordinate reference system
of the result.}
}
\description{
Convert origin-destination coordinates into desire lines
}
\examples{
odf <- od_coords(l = flowlines_sf)
odlines <- od_coords2line(odf)
odlines <- od_coords2line(odf, crs = 4326)
plot(odlines)
}
\seealso{
Other od: \code{\link{dist_google}}, \code{\link{od2line}},
  \code{\link{od2odf}}, \code{\link{od_aggregate_from}},
  \code{\link{od_aggregate_to}},
  \code{\link{od_aggregate}}, \code{\link{od_coords}},
  \code{\link{od_dist}}, \code{\link{od_radiation}},
  \code{\link{points2flow}}, \code{\link{points2odf}},
  \code{\link{sp_aggregate}}
}
\concept{od}
