% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_code.R
\name{geo_code}
\alias{geo_code}
\title{Convert text strings into points on the map}
\usage{
geo_code(address, service = "nominatim",
  base_url = "https://maps.google.com/maps/api/geocode/json",
  return_all = FALSE, pat = NULL)
}
\arguments{
\item{address}{Text string representing the address you want to geocode}

\item{service}{Which service to use? Nominatim by default}

\item{base_url}{The base url to query}

\item{return_all}{Should the request return all information returned by Google Maps?
The default is \code{FALSE}: to return only two numbers: the longitude and latitude, in that order}

\item{pat}{The API key used. By default this is set to NULL and
this is usually aquired automatically through a helper, api_pat().}
}
\description{
Generate a lat/long pair from data using Google's geolocation API.
}
\examples{
\dontrun{
geo_code(address = "Hereford")
geo_code("LS7 3HB")
geo_code("hereford", return_all = TRUE)
# needs api key in .Renviron
geo_code("hereford", service = "google", pat = Sys.getenv("GOOGLE"), return_all = TRUE)
}
}
\seealso{
Other nodes: \code{\link{locate2spdf}},
  \code{\link{nearest_google}}, \code{\link{nearest_osm}}
}
\concept{nodes}
