% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overline.R
\name{overline2}
\alias{overline2}
\title{Convert series of overlapping lines into a route network (new method)}
\usage{
overline2(x, attrib, ncores = 1, simplify = TRUE,
  regionalise = 1e+05)
}
\arguments{
\item{x}{An SF data.frame of LINESTRINGS}

\item{attrib}{character, column names in x to be summed}

\item{ncores}{integer, how many cores to use in parallel processing, default = 1}

\item{simplify}{logical, if TRUE group final segments back into lines, default = TRUE}

\item{regionalise}{integer, during simplification regonalisation is used if the number of segments exceeds this value}
}
\value{
An SF data.frame of LINESTRINGS
}
\description{
This function is intended as a replacement for overline() and is significantly faster
especially on large datasets. However, it also uses more memory.
}
\details{
The overline2 function breaks each line into many straight segments and then looks for duplicated segments.
Attributes are summed for all duplicated segments, and if simplify is TRUE the segments with identical attributes are
recombined into linestrings.

Regionalisation breaks the dataset into a 10 x 10 grid and then performed the simplification across each grid.
This significantly reduces computation time for large datasets, but slightly increases the final file size.
For smaller datasets it increases computation time slightly but reduces memory usage and so may also be useful.

A known limitation of this method is that overlapping segments of different lengths are not aggregated.
This can occur when lines stop halfway down a road. Typically these errors are small,
but some artefacts may remain within the resulting data.

For very large datasets nrow(x) > 1000000, memory usage can be significant. In these cases is is possible
to overline subsets of the dataset, rbind the results together, and then overline again, to produce
a final result.

Multicore support is only enabled for the regionalised simplification stage as it does not help with other stages.
}
\examples{
sl = routes_fast_sf[routes_fast_sf$length > 0, ]
sl$bicycle = 1
system.time({rnet1 = overline2(sl, "bicycle")})
system.time({rnet2 = overline2(sl, "bicycle", ncores = 4)})
identical(rnet1, rnet2)
lwd = rnet1$bicycle / mean(rnet1$bicycle)
plot(rnet1, lwd = lwd)
\donttest{
region = "isle-of-wight"

u = paste0(
  "https://github.com/npct/pct-outputs-regional-notR/raw/master/commute/msoa/",
   region,
  "/rf.geojson"
)

sl = sf::read_sf(u)
system.time({rnet1 = overline2(sl, "bicycle")})
system.time({rnet2 = overline2(sl, "bicycle", ncores = 4)})
identical(rnet1, rnet2)
lwd = rnet1$bicycle / mean(rnet1$bicycle)
plot(rnet1, lwd = lwd)
}
}
\seealso{
Other rnet: \code{\link{SpatialLinesNetwork}},
  \code{\link{calc_catchment_sum}},
  \code{\link{calc_catchment}},
  \code{\link{calc_moving_catchment}},
  \code{\link{calc_network_catchment}},
  \code{\link{find_network_nodes}}, \code{\link{gsection}},
  \code{\link{islines}}, \code{\link{lineLabels}},
  \code{\link{overline}},
  \code{\link{plot,SpatialLinesNetwork,ANY-method}},
  \code{\link{plot,sfNetwork,ANY-method}},
  \code{\link{sln2points}},
  \code{\link{sum_network_links}},
  \code{\link{sum_network_routes}}
}
\author{
Malcolm Morgan
}
\concept{rnet}
