% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route_local.R
\name{route_local}
\alias{route_local}
\title{Plan a route with local data}
\usage{
route_local(sln, from, to, l = NULL)
}
\arguments{
\item{sln}{The SpatialLinesNetwork to use.}

\item{from}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth.}

\item{to}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth. This represents the destination of the trip.}

\item{l}{Only needed if from and to are empty, in which case this
should be a spatial object representing desire lines}
}
\description{
This function returns the shortest path between locations
in, or near to, segements on a \code{SpatialLinesNetwork}.
}
\examples{
from <- c(-1.535181, 53.82534)
to <- c(-1.52446, 53.80949)
sln <- SpatialLinesNetwork(route_network_sf)
r <- route_local(sln, from, to)
plot(sln)
plot(r$geometry, add = TRUE, col = "red", lwd = 5)
plot(cents[c(3, 4), ], add = TRUE)
r2 <- route_local(sln = sln, cents_sf[3, ], cents_sf[4, ])
plot(r2$geometry, add = TRUE, col = "blue", lwd = 3)
}
\seealso{
Other routes: 
\code{\link{line2routeRetry}()},
\code{\link{line2route}()},
\code{\link{route_cyclestreet}()},
\code{\link{route_dodgr}()},
\code{\link{route_graphhopper}()},
\code{\link{route_transportapi_public}()},
\code{\link{route}()}
}
\concept{routes}
