% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnet-clean.R
\name{rnet_breakup_vertices}
\alias{rnet_breakup_vertices}
\title{Break up an sf object with LINESTRING geometry by vertex/nodes intersections}
\usage{
rnet_breakup_vertices(rnet, breakup_internal_vertex_matches = TRUE)
}
\arguments{
\item{rnet}{An sf LINESTRING object representing a route network.}

\item{breakup_internal_vertex_matches}{Should breaks be made at internal
vertex matches? \code{TRUE} by default. Internal vertices are vertices (but not
start or end points) of two or more different linestrings that meet at the
same point.}
}
\value{
The same sf LINESTRING object with more rows (the result of the
splitting) when there are intersecting (and internal) vertices.
}
\description{
This function breaks-up a single linestrings into multiple linestring at points
where vertices from other linestrings in the network intersect with vertices in the original linestring.
See \href{https://github.com/ropensci/stplanr/issues/282}{github.com/ropensci/stplanr/issues/282} for details.
}
\examples{
library(sf)
par(mar = rep(0, 4))

# Check for roundabout
plot(rnet_roundabout$geometry, lwd = 2, col = rainbow(nrow(rnet_roundabout)))

rnet_roundabout_clean <- rnet_breakup_vertices(rnet_roundabout)
plot(rnet_roundabout_clean$geometry, lwd = 2, col = rainbow(nrow(rnet_roundabout_clean)))
# Check for overpasses
plot(rnet_overpass$geometry, lwd = 2, col = rainbow(nrow(rnet_overpass)))

rnet_overpass_clean <- rnet_breakup_vertices(rnet_overpass)
plot(rnet_overpass_clean$geometry, lwd = 2, col = rainbow(nrow(rnet_overpass_clean)))
# mapview(rnet_overpass_clean) # to see interactively
# Check for intersection with no node
plot(rnet_cycleway_intersection$geometry, lwd = 2,
     col = rainbow(nrow(rnet_cycleway_intersection)))

rnet_cycleway_intersection_clean <- rnet_breakup_vertices(rnet_cycleway_intersection)
plot(rnet_cycleway_intersection_clean$geometry,
     lwd = 2, col = rainbow(nrow(rnet_cycleway_intersection_clean)))
}
