% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialLinesNetwork.R
\name{sum_network_links}
\alias{sum_network_links}
\title{Summarise links from shortest paths data}
\usage{
sum_network_links(sln, routedata)
}
\arguments{
\item{sln}{The SpatialLinesNetwork or sfNetwork to use.}

\item{routedata}{A dataframe where the first column contains the Node ID(s)
of the start of the routes, the second column indicates the Node ID(s) of
the end of the routes, and any additional columns are summarised by link.
If there are no additional colums, then overlapping routes are counted.}
}
\description{
Summarise links from shortest paths data
}
\section{Details}{

Find the shortest path on the network between specified nodes and returns
a SpatialLinesDataFrame or sf containing the path(s) and summary statistics
of each one.
}

\examples{
sln_sf <- SpatialLinesNetwork(route_network_sf)
plot(sln_sf)
nodes_df <- data.frame(
    start = rep(c(1, 2, 3, 4, 5), each = 4),
    end = rep(c(50, 51, 52, 33), times = 5)
  )
weightfield(sln_sf) # field used to determine shortest path
library(sf)
shortpath_sf <- sum_network_links(sln_sf, nodes_df)
plot(shortpath_sf["count"], lwd = shortpath_sf$count, add = TRUE)
}
\seealso{
Other rnet: 
\code{\link{SpatialLinesNetwork}},
\code{\link{calc_catchment_sum}()},
\code{\link{calc_catchment}()},
\code{\link{calc_moving_catchment}()},
\code{\link{calc_network_catchment}()},
\code{\link{find_network_nodes}()},
\code{\link{gsection}()},
\code{\link{islines}()},
\code{\link{lineLabels}()},
\code{\link{overline}()},
\code{\link{plot,SpatialLinesNetwork,ANY-method}},
\code{\link{plot,sfNetwork,ANY-method}},
\code{\link{rnet_breakup_vertices}()},
\code{\link{sln2points}()},
\code{\link{sum_network_routes}()}
}
\concept{rnet}
