% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route_google.R
\name{route_google}
\alias{route_google}
\title{Find shortest path using Google services}
\usage{
route_google(from, to, mode = "walking", key = Sys.getenv("GOOGLE"), ...)
}
\arguments{
\item{from}{An object representing origins
(if lines are provided as the first argument, from is assigned to \code{l})}

\item{to}{An object representing destinations}

\item{mode}{Mode of transport, walking (default), bicycling, transit, or driving}

\item{key}{Google key. By default it is \code{Sys.getenv("GOOGLE")}. Set it with:
\code{usethis::edit_r_environ()}.}

\item{...}{Arguments passed to the routing function, e.g. \code{\link[=route_cyclestreets]{route_cyclestreets()}}}
}
\description{
Find the shortest path using Google's services.
See the \code{mapsapi} package for details.
}
\examples{
\dontrun{
from = "university of leeds"
to = "pedallers arms leeds"
r = route(from, to, route_fun = cyclestreets::journey)
plot(r)
# r_google <- route(from, to, route_fun = mapsapi::mp_directions) # fails
r_google1 <- route_google(from, to)
plot(r_google1)
r_google <- route(from, to, route_fun = route_google)
}
}
