% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overline.R
\name{gsection}
\alias{gsection}
\title{Function to split overlapping SpatialLines into segments}
\usage{
gsection(sl, buff_dist = 0)
}
\arguments{
\item{sl}{SpatialLinesDataFrame with overlapping Lines to split by
number of overlapping features.}

\item{buff_dist}{A number specifying the distance in meters of the buffer to be used to crop lines before running the operation.
If the distance is zero (the default) touching but non-overlapping lines may be aggregated.}
}
\description{
Divides SpatialLinesDataFrame objects into separate Lines.
Each new Lines object is the aggregate of a single number
of aggregated lines.
}
\examples{
lib_versions <- sf::sf_extSoftVersion()
lib_versions
# fails on some systems (with early versions of PROJ)
if (lib_versions[3] >= "6.3.1") {
  sl <- routes_fast_sf[2:4, ]
  rsec <- gsection(sl)
  length(rsec) # sections
  plot(rsec, col = seq(length(rsec)))
  rsec <- gsection(sl, buff_dist = 50)
  length(rsec) # 4 features: issue
  plot(rsec, col = seq(length(rsec)))
}
}
\seealso{
Other rnet: 
\code{\link{islines}()},
\code{\link{overline}()},
\code{\link{rnet_breakup_vertices}()},
\code{\link{rnet_group}()}
}
\concept{rnet}
