% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.pred.R
\name{HP.pred}
\alias{HP.pred}
\title{Prediction of Heligman-Pollard model.}
\usage{
HP.pred(life, HPout, M = "med", age = seq(0, 29, 0.1), rm = 0)
}
\arguments{
\item{life}{A life table created with \link{life.tab} or a dataframe with a vector of ages in the first column.}

\item{HPout}{A model object created with \link{HP.mod} with the Heligman-Pollard estimated params.}

\item{M}{Defines the statistic to predict. Median by default (med), Low CI (low) or High CI (high)}

\item{age}{A vector containing the ages at which each age interval begins. See Details}

\item{rm}{The number of age classes that want to be removed from optimization.}
}
\value{
A dataframe with seven columns:
\item{age}{Age at the beginning of the interval.}
\item{Mx}{Number of observed deaths at age x.}
\item{qx.tot}{Total probability of death between ages x and x + n.}
\item{qx.nat}{Natural probability of death between ages x and x + n.}
\item{qx.young}{Young probability of death between ages x and x + n.}
\item{qx.risk}{Probability of death due to an externl risk between ages x and x + n.}
\item{qx.adult}{Adult or senescent probability of death between ages x and x + n.}
}
\description{
Predicts Heligman-Pollard model from Heligman-Pollard's parameters.
}
\details{
Mx is returned only if number of ages required for prediction is equal to the number of ages in the life table.
}
\examples{

lifeN <- life.tab(cetaceans)

modSi <- Si.mod(data = cetaceans, rm = 2,
                par = c(0.3159462,  0.1860541, -1.2802880,  1.1733226,  0.0170314))

dataSi <- Si.pred(data = cetaceans, Sout = modSi, rm = 2)

priors <- data.frame(priors.lo = c(0,0.5,0,0,0,0,6,0,1),
                     priors.hi = c(0.1,1,1,0.15,0.15,50,10,0.01,1.5))

q0 <- HP.priors(pri.lo = priors$priors.lo,
                pri.hi = priors$priors.hi,
                theta.dim = 9)

modHP <- HP.mod(prior = q0, lifeTab = lifeN, rm = 2, K = 10, d = 10, B = 10, CI = 90)

HP.pred(life = lifeN, HPout = modHP, age = seq(0,29,1), rm = 2)

}
\references{
Heligman, L. and Pollard, J.H. (1980). The Age Pattern of Mortality. Journal of the Institute of Actuaries 107:49–80.

Sharrow, D.J., Clark, S.J., Collinson, M.A., Kahn, K. and Tollman, S.M. (2013). The Age Pattern of Increases in Mortality Affected by HIV: Bayesian Fit of the Heligman-Pollard Model to Data from the Agincourt HDSS Field Site in Rural Northeast South Africa. Demogr. Res. 29, 1039–1096.
}
\seealso{
\link{HP.mod}
}
\keyword{Heligman-Pollard}
\keyword{mortality}
\keyword{prediction}
