% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.CI.R
\name{hp.nqx}
\alias{hp.nqx}
\title{Heligman-Pollard parameter conversion to age-specifc probabilites of death.}
\usage{
hp.nqx(HPout, age, M = "total")
}
\arguments{
\item{HPout}{A model object created with \link{HP.mod} with the Heligman-Pollard estimated params.}

\item{age}{A vector containing the ages at which the probability of death will be calculated.}

\item{M}{The type of probabilities to be calculated. Can be both "natural" mortality, "total" mortality and mortality due to an external risk.}
}
\value{
Set of age specific probabilities of death equal to the length of age.
}
\description{
Converts a set of Heligman-Pollard mortality model parameters into age-specific probabilities of death.
}
\note{
Utility function called by \code{\link{HP.CI}}.
}
\references{
Heligman, L. and Pollard, J.H. (1980). The Age Pattern of Mortality. Journal of the Institute of Actuaries 107:49–80.
}
\seealso{
\code{\link{HP.CI}}
}
\keyword{Heligman-Pollard}
\keyword{mortality}
\keyword{probability}
