% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.mod.R
\name{prior.likewts}
\alias{prior.likewts}
\title{Prior likelihoods and weights.}
\usage{
prior.likewts(prior, nrisk, ndeath, age, theta.dim = 9)
}
\arguments{
\item{prior}{A ((theta.dim * 1000) * theta.dim) matrix containing the prior distribution.}

\item{nrisk}{A vector containing the number of persons at risk in each age group.}

\item{ndeath}{A vector containing the number of deaths in each age group.}

\item{age}{A vector containing the ages at which each age interval begins.}

\item{theta.dim}{Number of columns of the prior matrix.}
}
\value{
\item{wts.0}{A vector containing an importance weight for each set of parameters from the prior.}
\item{log.like.0}{A vector containing a log likelihood for each set of parameters from the prior.}
}
\description{
Calculates the log-likelihood and importance weight for each set (i.e. each row) of Heligman-Pollard parameters in the prior.
}
\note{
Used in the \link{loop.optim} function
}
\references{
Heligman, L. and Pollard, J.H. (1980). The Age Pattern of Mortality. Journal of the Institute of Actuaries 107:49–80.

Poole, D and Raftery, A. (2000). Inference for Deterministic Simulation Models: The Bayesian Melding Approach. Journal of the American Statistical Association 95:1244–1255.

Raftery, A. and Bao, L. (2009). Estimating and Projecting Trends in HIV/AIDS Gen- eralized Epidemics Using Incremental Mixture Importance Sampling. Technical Report 560, Department of Statistics, University of Washington.

Sharrow, D.J., Clark, S.J., Collinson, M.A., Kahn, K. and Tollman, S.M. (2013). The Age Pattern of Increases in Mortality Affected by HIV: Bayesian Fit of the Heligman-Pollard Model to Data from the Agincourt HDSS Field Site in Rural Northeast South Africa. Demogr. Res. 29, 1039–1096.
}
\seealso{
\link{mod} \link{ll.binom} \link{loop.optim} \link{HP.mod}
}
\keyword{Heligman-Pollard}
\keyword{bycatch}
\keyword{mortality}
\keyword{priors}
