% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gelato.run}
\alias{gelato}
\alias{gelato.run}
\title{GELATo - Group ExcLusion and Assignment Test}
\usage{
gelato.run(g, unknown.strata, nrep = 1000, min.sample.size = 5,
  num.cores = 1)
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}

\item{unknown.strata}{a character vector listing to assign. Strata must occur in \code{g}.}

\item{nrep}{number of permutation replicates for Fst distribution.}

\item{min.sample.size}{minimum number of samples to use to characterize knowns. If
the known sample size would be smaller than this after drawing an equivalent
number of unknowns for self-assignment, then the comparison is not done.}

\item{num.cores}{number of CPU cores to use. Value is passed to \code{\link[parallel]{mclapply}}.}
}
\value{
A list with the following elements:
\tabular{ll}{
  \code{assign.prob} \tab a data.frame of assignment probabilities.\cr
  \code{likelihoods} \tab a list of likelihoods.\cr
}
}
\description{
Run a GELATo test to evaluate assignment likelihoods of
  groups of samples.
}
\examples{
data(dolph.strata)
data(dolph.msats)
msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5)

msat.gelato <- gelato.run(msats, "Offshore.South", nrep = 20)
gelato.plot(msat.gelato, "Offshore.South")
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
O'Corry-Crowe et. al. XXXX
}
\seealso{
\code{\link{gelato.plot}}
}

