% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/align.clustal.R
\name{align.clustal}
\alias{align.clustal}
\title{CLUSTAL Alignment}
\usage{
align.clustal(x, gapopen = 5, gapext = 15, trans.weight = 0.5,
  input.name = "to_align", output.format = "CLUSTAL",
  output.name = "aligned_seqs", delete.output = TRUE)
}
\arguments{
\item{x}{a \code{\link{gtypes}} object with aligned sequences, or a list of aligned DNA sequences.}

\item{gapopen}{penalty for gap opening.}

\item{gapext}{penalty for gap extension.}

\item{trans.weight}{transition weighting.}

\item{input.name}{name of input file (without extension).}

\item{output.format}{format of output file ("CLUSTAL", "PHYLIP", "NEXUS").}

\item{output.name}{name of output file (without extension).}

\item{delete.output}{delete the output file when finished?}
}
\value{
list of aligned sequences
}
\description{
Align sequences using CLUSTAL
}
\note{
Formats and executes a call to the executable \emph{clustalw2}, assuming that it is installed
  on the system and available at the command line.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
CLUSTALW2 is available at: \url{http://www.clustal.org/clustal2}
}

