% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharedLoci.R
\name{sharedLoci}
\alias{propSharedIds}
\alias{propSharedLoci}
\alias{sharedAlleles}
\alias{sharedLoci}
\title{Shared Loci}
\usage{
propSharedLoci(g, type = c("strata", "ids"), num.cores = NULL)

sharedAlleles(g, smry = c("num", "which"))

propSharedIds(ids, g)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{type}{a character vector determining type of pairwise comparsion. Can 
be "strata" for strata or "ids" for individuals.}

\item{num.cores}{number of CPU cores to use. Defaults to the number reported 
by \code{\link[parallel]{detectCores}} - 1.}

\item{smry}{a character vector determining type of summary for 
\code{sharedAlleles}. "which" returns the names of the alleles shared. 
"num" returns the number of alleles shared.}

\item{ids}{character vector of two sample ids to compare.}
}
\value{
data.frame summary of pairwise shared loci.
}
\description{
Calculate proportion of alleles and number of loci shared 
  between pairs of individuals or strata.
}
\examples{
data(msats.g)
msats.g <- stratify(msats.g, "fine")

sharedAlleles(msats.g)

\dontrun{
propSharedLoci(msats.g, num.cores = 2)
}

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

