% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popGenEqns.R
\name{popGenEqns}
\alias{popGenEqns}
\alias{wrightFst}
\alias{numGensEq}
\alias{fstToNm}
\alias{expectedNumAlleles}
\title{Population Genetics Equations}
\usage{
wrightFst(Ne, dispersal, gen.time, ploidy)

numGensEq(fst, Ne, gen.time)

fstToNm(fst, ploidy)

expectedNumAlleles(n, theta, ploidy)
}
\arguments{
\item{Ne}{Effective population size.}

\item{dispersal}{Migration rate in terms of probability of an individual 
migrating in a generation.}

\item{gen.time}{Number of generations since ancestral population.}

\item{ploidy}{Ploidy of the locus.}

\item{fst}{value of Fst at equilibrium.}

\item{n}{Sample size.}

\item{theta}{Product of effective population size (Ne) and mutation rate (mu).}
}
\value{
\describe{
  \item{wrightFst}{}
  \item{numGensEq}{}
  \item{fstToNm}{}
  \item{expectedNumAlleles}{a two element vector with the expected number of alleles
  (\code{num.alleles}) and variance (\code{var.num.alleles}).}
}
}
\description{
Collection of classical population genetics equations.
}
\details{
\describe{
  \item{wrightFst}{Calculate Wright's Fst from Ne, dispersal, and generation time.}
  \item{numGensEq}{Calculate the number of generations to equilibrium based on a an
  ideal Wright model.}
  \item{fstToNm}{Calculate Nm (number of migrants per generation) for a 
  given value of Fst.}
  \item{expectedNumAlleles}{Calculate the expected number of alleles in a sample of a
  given size and value of theta.}
}
}
\examples{
dispersal <- seq(0.05, 0.8, by = 0.05)
fst <- wrightFst(100, dispersal, 20, 2)
plot(dispersal, fst, type = "l")

numGensEq(0.15, 100, 20)
numGensEq(0.3, 100, 20)
numGensEq(0.15, 50, 20)

fst <- seq(0.001, 0.2, length.out = 100)
Nm <- fstToNm(fst, 2)
plot(fst, Nm, type = "l")

expectedNumAlleles(20, 1, 2)
# double the samples
expectedNumAlleles(40, 1, 2)
# for a haploid locus
expectedNumAlleles(40, 1, 1)
# double theta
expectedNumAlleles(40, 2, 1)

}
\references{
Ewens, W. 1972. The sampling theory of selectively neutral
  alleles. Theoretical Population Biology 3:87-112. Eqns. 11 and 24.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
