% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strata_object_constructors.R
\name{new_auto_strata}
\alias{new_auto_strata}
\title{New Autostrata}
\usage{
new_auto_strata(outcome, treat, analysis_set = NULL, call = NULL,
  issue_table = NULL, strata_table = NULL, prognostic_scores = NULL,
  prognostic_model = NULL, pilot_set = NULL)
}
\arguments{
\item{outcome}{a string giving the name of the column where outcome
information is stored}

\item{treat}{a string giving the name of the column where treatment
information is stored}

\item{analysis_set}{the data set which will be stratified}

\item{call}{the call to \code{auto_stratify} used to generate this object}

\item{issue_table}{a table of each stratum and potential issues of size and
treat:control balance}

\item{strata_table}{a table of each stratum and the prognostic score quantile
bin this corresponds to}

\item{prognostic_scores}{a vector of prognostic scores.}

\item{prognostic_model}{a model for prognosis fit on a separate data set.}

\item{pilot_set}{the set of controls used to fit the prognostic model.
These are excluded from subsequent analysis so that the prognostic score is
not overfit to the data used to estimate the treatment effect.}
}
\value{
a basic \code{auto_strata} object
}
\description{
Basic constructor for an \code{auto_strata} object. These objects hold all
the information associated with a dataset that has been stratified via
\code{\link{auto_stratify}}.  This object may be passed to
\code{\link{strata_match}} to be matched or it may be unpacked by the user to be
matched by other means.
}
\seealso{
\code{\link{auto_stratify}}, a function which calls this constructor
  to produce an \code{auto_strata} object.
}
