% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD_ReadSocket.R
\name{DSD_ReadSocket}
\alias{DSD_ReadSocket}
\title{A DSD That Reads from a Server Port}
\usage{
DSD_ReadSocket(host = "localhost", port, sleep = 2, ...)
}
\arguments{
\item{host}{hostname.}

\item{port}{host port.}

\item{sleep}{number of seconds to wait to establish the connection.}

\item{...}{further arguments are passed on to \code{\link[=DSD_ReadStream]{DSD_ReadStream()}}.}
}
\value{
A \link[stream:DSD]{stream::DSD} object.
}
\description{
Creates a \code{DSD_ReadStream} that reads from a port.
}
\examples{
# find a free port
port <- httpuv::randomPort()
port

# create a background DSD process sending data to port 8001
rp1 <- DSD_Gaussians(k = 3, d = 3) \%>\% publish_DSD_via_Socket(port = port)
rp1

Sys.sleep(2)  # wait for the socket to become available

# create a DSD that connects to the socket. Note that we need to 
# specify the column names of the stream
dsd <- DSD_ReadSocket(port = port, col.names = c("x", "y", "z", ".class"))
dsd

get_points(dsd, n = 10)

plot(dsd)

close_stream(dsd)

# end the DSD process. Note: that closing the connection above
# may already kill the process.
if (rp1$is_alive()) rp1$kill()
rp1
}
\seealso{
Other Socket: 
\code{\link{publish_DSD_via_Socket}()}

Other dsd: 
\code{\link{DSD_ReadWebService}()},
\code{\link{publish_DSD_via_Socket}()},
\code{\link{publish_DSD_via_WebService}()}
}
\concept{Socket}
\concept{dsd}
