% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs_plot.r
\name{plot.streambugs}
\alias{plot.streambugs}
\title{Plot the results of streambugs ODE run}
\usage{
\method{plot}{streambugs}(x, y, inp = NA, ...)
}
\arguments{
\item{x}{matrix with results derived by
\code{\link{run.streambugs}}}

\item{y}{same as \code{par} in \code{\link{run.streambugs}}}

\item{inp}{same as \code{inp} in \code{\link{run.streambugs}}}

\item{...}{additional argument for the \code{\link[graphics]{plot}} function
call}
}
\description{
Plot time series of all streambugs ODE state variables, for each reach,
habitat and group, resulting from the
\code{\link{run.streambugs}} function call.
}
\examples{
m <- streambugs.example.model.toy()
r <- run.streambugs(y.names=m$y.names, times=m$times,  par=m$par, inp=m$inp, C=TRUE)
plot(x=r$res, y=m$par, inp=m$inp)

}
