% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_detect_fixed}
\alias{stri_detect_fixed}
\title{Detect a Fixed Pattern Match}
\usage{
stri_detect_fixed(str, pattern)
}
\arguments{
\item{str}{character vector}

\item{pattern}{character vector}
}
\value{
Returns a logical vector.
}
\description{
This function checks if there is at least one occurrence of a fixed pattern
in a string.
}
\details{
Vectorized over \code{str} and \code{pattern}.

For natural language processing this function may be not give
you desired results. Refer to \link{stringi-search-fixed} for more details.

If \code{pattern} is empty, then the result is \code{NA}
and a warning is generated.
}
\examples{
stri_detect_fixed(c("stringi R", "REXAMINE", "123"), c('i', 'R', '0'))
stri_detect_fixed(c("stringi R", "REXAMINE", "123"), 'R')
}
\seealso{
Other search_detect: \code{\link{stri_detect_charclass}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_detect_regex}};
  \code{\link{stri_detect}}; \code{\link{stringi-search}}

Other search_fixed: \code{\link{stri_count_fixed}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_replace_all_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_last_fixed}},
  \code{\link{stri_replace_last_fixed}};
  \code{\link{stri_split_fixed}};
  \code{\link{stringi-search-fixed}};
  \code{\link{stringi-search}}
}

