% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_extract_all}
\alias{stri_extract}
\alias{stri_extract_all}
\alias{stri_extract_all_charclass}
\alias{stri_extract_all_coll}
\alias{stri_extract_all_regex}
\alias{stri_extract_first}
\alias{stri_extract_first_charclass}
\alias{stri_extract_first_coll}
\alias{stri_extract_first_regex}
\alias{stri_extract_last}
\alias{stri_extract_last_charclass}
\alias{stri_extract_last_coll}
\alias{stri_extract_last_regex}
\title{Extract Occurrences of a Pattern}
\usage{
stri_extract_all(str, ..., regex, coll, charclass)

stri_extract_first(str, ..., regex, coll, charclass)

stri_extract_last(str, ..., regex, coll, charclass)

stri_extract(str, ..., regex, coll, charclass, mode = c("first", "all",
  "last"))

stri_extract_all_charclass(str, pattern, merge = TRUE, simplify = FALSE)

stri_extract_first_charclass(str, pattern)

stri_extract_last_charclass(str, pattern)

stri_extract_all_coll(str, pattern, simplify = FALSE, opts_collator = NULL)

stri_extract_first_coll(str, pattern, opts_collator = NULL)

stri_extract_last_coll(str, pattern, opts_collator = NULL)

stri_extract_all_regex(str, pattern, simplify = FALSE, opts_regex = NULL)

stri_extract_first_regex(str, pattern, opts_regex = NULL)

stri_extract_last_regex(str, pattern, opts_regex = NULL)
}
\arguments{
\item{str}{character vector with strings to search in}

\item{...}{additional arguments passed to the underlying functions}

\item{mode}{single string;
one of: \code{"first"} (the default), \code{"all"}, \code{"last"}}

\item{pattern,regex,coll,charclass}{character vector defining search patterns;
for more details refer to \link{stringi-search}}

\item{merge}{single logical value;
should consecutive matches be merged into one string;  \code{stri_extract_all_charclass} only}

\item{simplify}{single logical value;
if \code{TRUE}, then a character matrix is returned;
otherwise (the default), a list of character vectors is given, see Value;
\code{stri_extract_all_*} only}

\item{opts_collator}{a named list with \pkg{ICU} Collator's settings
as generated with \code{\link{stri_opts_collator}}; \code{NULL}
for default settings; \code{stri_extract_*_coll} only}

\item{opts_regex}{a named list with \pkg{ICU} Regex settings
as generated with \code{\link{stri_opts_regex}}; \code{NULL}
for default settings;
\code{stri_extract_*_regex} only}
}
\value{
For \code{stri_extract_all*}, if \code{simplify == FALSE} (the default), then
a list of character vectors is returned. Each list element
represents the results of a separate search scenario.
If a pattern is not found, then a character vector of length 1,
with single \code{NA} value will be generated.
Otherwise, i.e. if \code{simplify == TRUE},
then \code{\link{stri_list2matrix}} with \code{byrow=TRUE} argument
is called on the resulting object.
In such a case, a character matrix with an appropriate number of rows
(according to the length of \code{str}, \code{pattern}, etc.)
is returned.

\code{stri_extract_first*} and \code{stri_extract_last*},
on the other hand, return a character vector.
A \code{NA} element indicates no match.
}
\description{
These functions extract all substrings matching a given pattern.

\code{stri_extract_all_*} extracts all the matches.
On the other hand, \code{stri_extract_first_*} and \code{stri_extract_last_*}
provide the first or the last matches, respectively.
}
\details{
Vectorized over \code{str} and \code{pattern}.

Note that a \code{stri_extract_*_fixed} family of functions does not
make sense. Thus, it has not been implemented in \pkg{stringi}.

If you would like to extract regex capture groups individually,
check out \code{\link{stri_match}}.

\code{stri_extract}, \code{stri_extract_all}, \code{stri_extract_first},
and \code{stri_extract_last} are convenience functions.
They just call \code{stri_extract_*_*}, depending on arguments used.
Unless you are a very lazy person, please call the underlying functions
directly for better performance.
}
\examples{
\donttest{
stri_extract_all('XaaaaX', regex=c('\\\\p{Ll}', '\\\\p{Ll}+', '\\\\p{Ll}{2,3}', '\\\\p{Ll}{2,3}?'))
stri_extract_all('Bartolini', coll='i')
stri_extract_all('stringi is so good!', charclass='\\\\p{Zs}') # all whitespaces

stri_extract_all_charclass(c('AbcdeFgHijK', 'abc', 'ABC'), '\\\\p{Ll}')
stri_extract_all_charclass(c('AbcdeFgHijK', 'abc', 'ABC'), '\\\\p{Ll}', merge=FALSE)
stri_extract_first_charclass('AaBbCc', '\\\\p{Ll}')
stri_extract_last_charclass('AaBbCc', '\\\\p{Ll}')

stri_extract_all_coll(c('AaaaaaaA', 'AAAA'), 'a')
stri_extract_first_coll(c('Yy\\u00FD', 'AAA'), 'y',
   stri_opts_collator(strength=2, locale="sk_SK"))
stri_extract_last_coll(c('Yy\\u00FD', 'AAA'), 'y',
   stri_opts_collator(strength=1, locale="sk_SK"))

stri_extract_all_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+', '\\\\p{Ll}{2,3}', '\\\\p{Ll}{2,3}?'))
stri_extract_first_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+', '\\\\p{Ll}{2,3}', '\\\\p{Ll}{2,3}?'))
stri_extract_last_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+', '\\\\p{Ll}{2,3}', '\\\\p{Ll}{2,3}?'))

stri_list2matrix(stri_extract_all_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+')))
stri_extract_all_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+'), simplify=TRUE)
}
}
\seealso{
Other search_extract: \code{\link{stri_extract_words}};
  \code{\link{stri_match}}, \code{\link{stri_match_all}},
  \code{\link{stri_match_all_regex}},
  \code{\link{stri_match_first}},
  \code{\link{stri_match_first_regex}},
  \code{\link{stri_match_last}},
  \code{\link{stri_match_last_regex}};
  \code{\link{stringi-search}}
}

