% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_locate_boundaries}
\alias{stri_locate_boundaries}
\alias{stri_locate_words}
\title{Locate Specific Text Boundaries}
\usage{
stri_locate_boundaries(str, opts_brkiter = NULL)

stri_locate_words(str, locale = NULL)
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{opts_brkiter}{a named list with \pkg{ICU} BreakIterator's settings
as generated with \code{\link{stri_opts_brkiter}};
\code{NULL} for default break iterator, i.e. \code{line_break};
\code{stri_locate_boundaries} only}

\item{locale}{\code{NULL} or \code{""} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale};
\code{stri_locate_words} only}
}
\value{
A list of \code{length(str)} integer matrices
is returned. The first column gives the start positions
of substrings between located boundaries, and the second column gives
the end positions. The indices are code point-based, thus
they may be passed e.g. to the \code{\link{stri_sub}} function.

Moreover, you may get two \code{NA}s in one row
for no match or \code{NA} arguments.
}
\description{
This function locates specific text boundaries
(like character, word, line, or sentence boundaries).
}
\details{
Vectorized over \code{str}.

For more information on the text boundary analysis
performed by \pkg{ICU}'s \code{BreakIterator}, see
\link{stringi-search-boundaries}.

In case of \code{stri_locate_words},
just like in \code{\link{stri_extract_words}} and \code{\link{stri_count_words}},
\pkg{ICU}'s word \code{BreakIterator} iterator is used
to locate word boundaries, and all non-word characters
(\code{UBRK_WORD_NONE} rule status) are ignored.
This is function is equivalent to a call to
\code{\link{stri_locate_boundaries}(str, \link{stri_opts_brkiter}(type="word", skip_word_none=TRUE, locale=locale))}
}
\examples{
\donttest{
test <- "The\\u00a0above-mentioned    features are very useful. Warm thanks to their developers."
stri_locate_boundaries(test, stri_opts_brkiter(type="line"))
stri_locate_boundaries(test, stri_opts_brkiter(type="word"))
stri_locate_boundaries(test, stri_opts_brkiter(type="sentence"))
stri_locate_boundaries(test, stri_opts_brkiter(type="character"))
stri_locate_words(test)
}
}
\seealso{
Other indexing: \code{\link{stri_locate}},
  \code{\link{stri_locate_all}},
  \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stri_sub}}, \code{\link{stri_sub<-}}

Other locale_sensitive: \code{\link{\%s!==\%}},
  \code{\link{\%s!=\%}}, \code{\link{\%s<=\%}},
  \code{\link{\%s<\%}}, \code{\link{\%s===\%}},
  \code{\link{\%s==\%}}, \code{\link{\%s>=\%}},
  \code{\link{\%s>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search-coll}}

Other search_locate: \code{\link{stri_locate}},
  \code{\link{stri_locate_all}},
  \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stringi-search}}

Other text_boundaries: \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_opts_brkiter}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_lines}},
  \code{\link{stri_split_lines1}},
  \code{\link{stri_split_lines1}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_wrap}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search}}
}

