% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stringi-search-charclass}
\alias{stringi-search-charclass}
\title{Character Classes in \pkg{stringi}}
\description{
In this man page we describe how character classes are
declared in the \pkg{stringi} package
so that you may e.g. find their occurrences in your search activities
or generate random code points with \code{\link{stri_rand_strings}}.
Moreover, \pkg{ICU} regex engines uses the same
scheme for denoting character classes.
}
\details{
All \code{stri_*_charclass} functions in \pkg{stringi} perform
a single character (i.e. Unicode code point) search-based operations.
Since stringi_0.2-1 you may obtain
roughly the same results using \link{stringi-search-regex}.
However, these very functions aim to be faster.

Character classes are defined using \pkg{ICU}'s \code{UnicodeSet}
patterns. Below we briefly summarize their syntax.
For more details refer to the bibliographic References below.
}
\section{\code{UnicodeSet} patterns}{


A \code{UnicodeSet} represents a subset of Unicode code points
(recall that \pkg{stringi} converts strings in your native encoding
to Unicode automatically). Legal code points are U+0000 to U+10FFFF,
inclusive.

Patterns either consist of series of characters either bounded by square brackets
(such patterns follow a syntax similar to that employed
by version 8 regular expression character classes)
or of Perl-like Unicode property set specifiers.

\code{[]} denotes an empty set, \code{[a]} --
a set consisting of character ``a'',
\code{[\\u0105]} -- a set with character U+0105,
and \code{[abc]} -- a set with ``a'', ``b'', and ``c''.

\code{[a-z]} denotes a set consisting of characters
``a'' through ``z'' inclusively, in Unicode code point order.

Some set-theoretic operations are available.
\code{^} denotes the complement, e.g. \code{[^a-z]} contains
all characters but ``a'' through ``z''.
On the other hand, \code{[[pat1][pat2]]},
\code{[[pat1]\&[pat2]]}, and \code{[[pat1]-[pat2]]}
denote union, intersection, and asymmetric difference of sets
specified by \code{pat1} and \code{pat2}, respectively.

Note that all white spaces are ignored unless they are quoted or backslashed
(white spaces can be freely used for clarity, as \code{[a c d-f m]}
means the same as \code{[acd-fm]}).
\pkg{stringi} does not allow for including so-called multicharacter strings
(see \code{UnicodeSet} API documentation).
Also, empty string patterns are disallowed.

Any character may be preceded by
a backslash in order to remove any special meaning.

A malformed pattern always results in an error.

Set expressions at a glance
(according to \url{http://userguide.icu-project.org/strings/regexp}):

\tabular{ll}{
\strong{Example}  \tab  \strong{Description}\cr
\code{[abc]} 	\tab Match any of the characters a, b or c\cr
\code{[^abc]} 	\tab Negation -- match any character except a, b or c\cr
\code{[A-M]} 	\tab Range -- match any character from A to M. The characters
to include are determined by Unicode code point ordering.\cr
\code{[\\u0000-\\U0010ffff]} 	\tab Range -- match all characters.\cr
\code{[\\p{Letter}]} or \code{[\\p{General_Category=Letter}]} or \code{[\\p{L}]} 	\tab
Characters with Unicode Category = Letter. All forms shown are equivalent.\cr
\code{[\\P{Letter}]} 	\tab Negated property.
(Upper case \code{\\P}) Match everything except Letters.\cr
\code{[\\p{numeric_value=9}]} 	\tab Match all numbers with a numeric value of 9.
Any Unicode Property may be used in set expressions.\cr
\code{[\\p{Letter}&&\\p{script=cyrillic}]} 	\tab Logical AND
or intersection -- match the set of all Cyrillic letters.\cr
\code{[\\p{Letter}--\\p{script=latin}]}  	\tab Subtraction --
match all non-Latin letters.\cr
\code{[[a-z][A-Z][0-9]]} or \code{[a-zA-Z0-9]}  	\tab Implicit Logical
OR or Union of Sets -- the examples match ASCII letters and digits.
The two forms are equivalent.\cr
\code{[:script=Greek:]} \tab Alternate POSIX-like syntax for properties --
equivalent to \code{\\p{script=Greek}}\cr
}
}

\section{Unicode properties}{


Unicode property sets are specified with a POSIX-like syntax,
e.g. \code{[:Letter:]},
or with a (extended) Perl-style syntax, e.g. \code{\\p{L}}.
The complements of the above sets are
\code{[:^Letter:]} and \code{\\P{L}}, respectively.

The properties' names are normalized before matching
(for example, the match is case-insensitive).
Moreover, many names have short aliases.

Among predefined Unicode properties we find e.g.
\itemize{
\item Unicode General Categories, e.g. \code{Lu} for uppercase letters,
\item Unicode Binary Properties, e.g. \code{WHITE_SPACE},
}
and many more (including Unicode scripts).

Each property provides access to the large and comprehensive
Unicode Character Database.
Generally, the list of properties available in \pkg{ICU}
is not perfectly documented. Please refer to the References section
for some links.

Please note that some classes may seem to overlap.
However, e.g. General Category \code{Z} (some space) and Binary Property
\code{WHITE_SPACE} matches different character sets.
}

\section{Unicode General Categories}{


The Unicode General Category property of a code point provides the most
general classification of that code point.
Each code point falls into one and only one Category.

\tabular{ll}{
 \code{Cc} \tab a C0 or C1 control code\cr
 \code{Cf} \tab a format control character\cr
 \code{Cn} \tab a reserved unassigned code point or a non-character\cr
 \code{Co} \tab a private-use character\cr
 \code{Cs} \tab a surrogate code point\cr
 \code{Lc} \tab the union of Lu, Ll, Lt\cr
 \code{Ll} \tab a lowercase letter\cr
 \code{Lm} \tab a modifier letter\cr
 \code{Lo} \tab other letters, including syllables and ideographs\cr
 \code{Lt} \tab a digraphic character, with first part uppercase\cr
 \code{Lu} \tab an uppercase letter\cr
 \code{Mc} \tab a spacing combining mark (positive advance width)\cr
 \code{Me} \tab an enclosing combining mark\cr
 \code{Mn} \tab a non-spacing combining mark (zero advance width)\cr
 \code{Nd} \tab a decimal digit\cr
 \code{Nl} \tab a letter-like numeric character\cr
 \code{No} \tab a numeric character of other type\cr
 \code{Pd} \tab a dash or hyphen punctuation mark\cr
 \code{Ps} \tab an opening punctuation mark (of a pair)\cr
 \code{Pe} \tab a closing punctuation mark (of a pair)\cr
 \code{Pc} \tab a connecting punctuation mark, like a tie\cr
 \code{Po} \tab a punctuation mark of other type\cr
 \code{Pi} \tab an initial quotation mark\cr
 \code{Pf} \tab a final quotation mark\cr
 \code{Sm} \tab a symbol of mathematical use\cr
 \code{Sc} \tab a currency sign\cr
 \code{Sk} \tab a non-letter-like modifier symbol\cr
 \code{So} \tab a symbol of other type\cr
 \code{Zs} \tab a space character (of non-zero width)\cr
 \code{Zl} \tab U+2028 LINE SEPARATOR only\cr
 \code{Zp} \tab U+2029 PARAGRAPH SEPARATOR only\cr
 \code{C}  \tab the union of Cc, Cf, Cs, Co, Cn\cr
 \code{L}  \tab the union of Lu, Ll, Lt, Lm, Lo\cr
 \code{M}  \tab the union of Mn, Mc, Me\cr
 \code{N}  \tab the union of Nd, Nl, No\cr
 \code{P}  \tab the union of Pc, Pd, Ps, Pe, Pi, Pf, Po\cr
 \code{S}  \tab the union of Sm, Sc, Sk, So\cr
 \code{Z}  \tab the union of Zs, Zl, Zp \cr
}
}

\section{Unicode Binary Properties}{


Each character may follow many Binary Properties at a time.

Here is a comprehensive list of supported Binary Properties:

\tabular{ll}{
  \code{ALPHABETIC}      \tab alphabetic character\cr
  \code{ASCII_HEX_DIGIT} \tab a character matching the \code{[0-9A-Fa-f]} charclass\cr
  \code{BIDI_CONTROL}    \tab a format control which have specific functions
                             in the Bidi (bidirectional text) Algorithm\cr
  \code{BIDI_MIRRORED}   \tab a character that may change display in right-to-left text\cr
  \code{DASH}            \tab a kind of a dash character\cr
  \code{DEFAULT_IGNORABLE_CODE_POINT} \tab characters that are ignorable in most
                               text processing activities,
                               e.g. <2060..206F, FFF0..FFFB, E0000..E0FFF>\cr
  \code{DEPRECATED}      \tab a deprecated character according
          to the current Unicode standard (the usage of deprecated characters
          is strongly discouraged)\cr
  \code{DIACRITIC}       \tab a character that linguistically modifies
             the meaning of another character to which it applies\cr
  \code{EXTENDER}        \tab a character that extends the value
                             or shape of a preceding alphabetic character,
                             e.g. a length and iteration mark.\cr
  \code{HEX_DIGIT}       \tab a character commonly
                            used for hexadecimal numbers,
                            cf. also \code{ASCII_HEX_DIGIT}\cr
  \code{HYPHEN} \tab a dash used to mark connections between
              pieces of words, plus the Katakana middle dot\cr
  \code{ID_CONTINUE} \tab a character that can continue an identifier,
                     \code{ID_START}+\code{Mn}+\code{Mc}+\code{Nd}+\code{Pc}\cr
  \code{ID_START} \tab a character that can start an identifier,
                 \code{Lu}+\code{Ll}+\code{Lt}+\code{Lm}+\code{Lo}+\code{Nl}\cr
  \code{IDEOGRAPHIC} \tab a CJKV (Chinese-Japanese-Korean-Vietnamese)
ideograph\cr
  \code{LOWERCASE} \tab \cr
  \code{MATH} \tab \cr
  \code{NONCHARACTER_CODE_POINT} \tab \cr
  \code{QUOTATION_MARK} \tab \cr
  \code{SOFT_DOTTED} \tab a character with a ``soft dot'', like i or j,
such that an accent placed on this character causes the dot to disappear\cr
  \code{TERMINAL_PUNCTUATION} \tab a punctuation character that generally
marks the end of textual units\cr
  \code{UPPERCASE} \tab \cr
  \code{WHITE_SPACE} \tab a space character or TAB or CR or LF or ZWSP or ZWNBSP\cr
  \code{CASE_SENSITIVE} \tab \cr
  \code{POSIX_ALNUM} \tab \cr
  \code{POSIX_BLANK} \tab \cr
  \code{POSIX_GRAPH} \tab \cr
  \code{POSIX_PRINT} \tab \cr
  \code{POSIX_XDIGIT} \tab \cr
  \code{CASED} \tab \cr
  \code{CASE_IGNORABLE} \tab \cr
  \code{CHANGES_WHEN_LOWERCASED} \tab \cr
  \code{CHANGES_WHEN_UPPERCASED} \tab \cr
  \code{CHANGES_WHEN_TITLECASED} \tab \cr
  \code{CHANGES_WHEN_CASEFOLDED} \tab \cr
  \code{CHANGES_WHEN_CASEMAPPED} \tab \cr
  \code{CHANGES_WHEN_NFKC_CASEFOLDED} \tab \cr
}
}

\section{POSIX Character Classes}{


Beware of using POSIX character classes,
e.g. \code{[:punct:]}. ICU User Guide (see below)
states that in general they are not well-defined, so may end up
with something different than you expect.

In particular, in POSIX-like regex engines, \code{[:punct:]} stands for
the character class corresponding to the \code{ispunct()} classification
function (check out \code{man 3 ispunct} on UNIX-like systems).
According to ISO/IEC 9899:1990 (ISO C90), the \code{ispunct()} function
tests for any printing character except for space or a character
for which \code{isalnum()} is true. However, in a POSIX setting,
the details of what characters belong into which class depend
on the current locale. So the \code{[:punct:]} class does not lead
to portable code (again, in POSIX-like regex engines).

So a POSIX flavor of \code{[:punct:]} is more like
\code{[\\p{P}\\p{S}]} in \pkg{ICU}. You have been warned.
}
\references{
\emph{The Unicode Character Database} -- Unicode Standard Annex #44,
\url{http://www.unicode.org/reports/tr44/}

\emph{UnicodeSet} -- ICU User Guide,
\url{http://userguide.icu-project.org/strings/unicodeset}

\emph{Properties} -- ICU User Guide,
\url{http://userguide.icu-project.org/strings/properties}

\emph{C/POSIX Migration} -- ICU User Guide,
\url{http://userguide.icu-project.org/posix}

\emph{Unicode Script Data}, \url{http://www.unicode.org/Public/UNIDATA/Scripts.txt}

\emph{icu::Unicodeset Class Reference} -- ICU4C API Documentation,
\url{http://www.icu-project.org/apiref/icu4c/classicu_1_1UnicodeSet.html}
}
\seealso{
Other search_charclass: \code{\link{stri_trim}},
  \code{\link{stri_trim}}, \code{\link{stri_trim_both}},
  \code{\link{stri_trim_left}},
  \code{\link{stri_trim_right}};
  \code{\link{stringi-search}}

Other stringi_general_topics: \code{\link{stringi-arguments}};
  \code{\link{stringi-encoding}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-package}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search-coll}};
  \code{\link{stringi-search-fixed}};
  \code{\link{stringi-search-regex}};
  \code{\link{stringi-search}}
}

