% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_replace_all}
\alias{stri_replace}
\alias{stri_replace_all}
\alias{stri_replace_all_charclass}
\alias{stri_replace_all_coll}
\alias{stri_replace_all_fixed}
\alias{stri_replace_all_regex}
\alias{stri_replace_first}
\alias{stri_replace_first_charclass}
\alias{stri_replace_first_coll}
\alias{stri_replace_first_fixed}
\alias{stri_replace_first_regex}
\alias{stri_replace_last}
\alias{stri_replace_last_charclass}
\alias{stri_replace_last_coll}
\alias{stri_replace_last_fixed}
\alias{stri_replace_last_regex}
\title{Replace Occurrences of a Pattern}
\usage{
stri_replace_all(str, replacement, ..., regex, fixed, coll, charclass)

stri_replace_first(str, replacement, ..., regex, fixed, coll, charclass)

stri_replace_last(str, replacement, ..., regex, fixed, coll, charclass)

stri_replace(str, replacement, ..., regex, fixed, coll, charclass,
  mode = c("first", "all", "last"))

stri_replace_all_charclass(str, pattern, replacement, merge = FALSE,
  vectorize_all = TRUE)

stri_replace_first_charclass(str, pattern, replacement)

stri_replace_last_charclass(str, pattern, replacement)

stri_replace_all_coll(str, pattern, replacement, vectorize_all = TRUE, ...,
  opts_collator = NULL)

stri_replace_first_coll(str, pattern, replacement, ..., opts_collator = NULL)

stri_replace_last_coll(str, pattern, replacement, ..., opts_collator = NULL)

stri_replace_all_fixed(str, pattern, replacement, vectorize_all = TRUE, ...,
  opts_fixed = NULL)

stri_replace_first_fixed(str, pattern, replacement, ..., opts_fixed = NULL)

stri_replace_last_fixed(str, pattern, replacement, ..., opts_fixed = NULL)

stri_replace_all_regex(str, pattern, replacement, vectorize_all = TRUE, ...,
  opts_regex = NULL)

stri_replace_first_regex(str, pattern, replacement, ..., opts_regex = NULL)

stri_replace_last_regex(str, pattern, replacement, ..., opts_regex = NULL)
}
\arguments{
\item{str}{character vector with strings to search in}

\item{replacement}{character vector with replacements for matched patterns}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{opts_collator}, \code{opts_regex},
\code{opts_fixed}, and so on}

\item{mode}{single string;
one of: \code{"first"} (the default), \code{"all"}, \code{"last"}}

\item{pattern,regex,fixed,coll,charclass}{character vector defining search patterns;
for more details refer to \link{stringi-search}}

\item{merge}{single logical value;
should consecutive matches be merged into one string;
\code{stri_replace_all_charclass} only}

\item{vectorize_all}{single logical value;
should each occurrence of a pattern in every string
be replaced by a corresponding replacement string?;
\code{stri_replace_all_*} only}

\item{opts_collator,opts_fixed,opts_regex}{a named list used to tune up
a search engine's settings; see
\code{\link{stri_opts_collator}}, \code{\link{stri_opts_fixed}},
and \code{\link{stri_opts_regex}}, respectively; \code{NULL}
for default settings;}
}
\value{
All the functions return a character vector.
}
\description{
These functions replace with the given replacement string every/first/last
substring of the input that matches the specified \code{pattern}.
}
\details{
By default, all the functions are vectorized over
\code{str}, \code{pattern}, \code{replacement}. Then
these functions scan the input string for matches of the pattern.
Input that is not part of any match is left unchanged;
each match is replaced in the result by the replacement string.

However, for \code{stri_replace_all*}, if \code{vectorize_all} is \code{FALSE},
the each substring matching any of the supplied \code{pattern}s
is replaced by a corresponding \code{replacement} string.
In such a case, the vectorization is over \code{str},
and - independently - over \code{pattern} and \code{replacement}.
In other words, this is equivalent to something like
\code{for (i in 1:npatterns) str <- stri_replace_all(str, pattern[i], replacement[i]}.
Note that you must set \code{length(pattern) >= length(replacement)}.

In case of \code{stri_replace_*_regex},
the replacement string may contain references to capture groups
(in round parentheses).
References are of the form \code{$n}, where \code{n} is the number
of the capture group (their numbering starts from 1).
In order to treat the \code{$} character literally,
escape it with a backslash.

\code{stri_replace}, \code{stri_replace_all}, \code{stri_replace_first},
and \code{stri_replace_last} are convenience functions.
They just call \code{stri_replace_*_*}, depending on arguments used.
Unless you are a very lazy person, please call the underlying functions
directly for better performance.

If you would like to get rid of e.g. whitespaces from the start or end
of a string, see \code{\link{stri_trim}}.
}
\examples{
stri_replace_all_charclass("aaaa", "[a]", "b", merge=c(TRUE, FALSE))

stri_replace_all_charclass("a\\nb\\tc   d", "\\\\p{WHITE_SPACE}", " ")
stri_replace_all_charclass("a\\nb\\tc   d", "\\\\p{WHITE_SPACE}", " ", merge=TRUE)

s <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit."
stri_replace_all_fixed(s, " ", "#")
stri_replace_all_fixed(s, "o", "0")

stri_replace_all_regex(s, " .*? ", "#")
stri_replace_all_regex(s, "(el|s)it", "1234")
stri_replace_all_regex('abaca', 'a', c('!', '*'))
stri_replace_all_regex('123|456|789', '(\\\\p{N}).(\\\\p{N})', '$2-$1')
stri_replace_all_regex(c("stringi R", "REXAMINE", "123"), '( R|R.)', ' r ')

# Compare the results:
stri_replace_all_fixed("The quick brown fox jumped over the lazy dog.",
     c("quick", "brown", "fox"), c("slow",  "black", "bear"), vectorize_all=TRUE)
stri_replace_all_fixed("The quick brown fox jumped over the lazy dog.",
     c("quick", "brown", "fox"), c("slow",  "black", "bear"), vectorize_all=FALSE)

# Compare the results:
stri_replace_all_fixed("The quicker brown fox jumped over the lazy dog.",
     c("quick", "brown", "fox"), c("slow",  "black", "bear"), vectorize_all=FALSE)
stri_replace_all_regex("The quicker brown fox jumped over the lazy dog.",
     "\\\\b"\%s+\%c("quick", "brown", "fox")\%s+\%"\\\\b", c("slow",  "black", "bear"), vectorize_all=FALSE)
}
\seealso{
Other search_replace: \code{\link{stri_replace_na}};
  \code{\link{stri_trim}}, \code{\link{stri_trim}},
  \code{\link{stri_trim_both}},
  \code{\link{stri_trim_left}},
  \code{\link{stri_trim_right}};
  \code{\link{stringi-search}}
}

