\name{calculateOL}
\alias{calculateOL}
\title{Off-ladder risk}
\usage{
calculateOL(kit, db, virtual = TRUE, limit = TRUE, debug = FALSE)
}
\arguments{
  \item{kit}{data.frame, providing kit information.}

  \item{db}{data.frame, allele frequency database.}

  \item{virtual}{logical default is TRUE, calculation
  includes virtual alleles.}

  \item{limit}{logical default is TRUE, limit small
  frequencies to 5/2N.}

  \item{debug}{logical indicating printing debug
  information.}
}
\description{
\code{calculateOL} analyse the risk for off-ladder alleles.
}
\details{
By analysing the allelic ladders the risk for getting
off-ladder (OL) alleles are calculated. The frequencies
from a provided population database is used to calculate
the risk per marker and in total for the given kit(s).
Virtual alleles can be excluded from the calculation. Small
frequencies can be limited to the estimate 5/2N.
}

